/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.adapters;

import com.appdynamics.android.bci.BaseClassVisitor;
import com.appdynamics.android.logging.BCIRunSummary;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.MethodVisitor;
import com.appdynamics.repackaged.asm.commons.Method;

public class ViewOnClickClassAdapter
extends BaseClassVisitor {
    private static final String ON_CLICK_LISTENER_INTERFACE_NAME = "android/view/View$OnClickListener";
    private static final String READABLE_TARGET_METHOD = "void onClick(android.view.View)";
    private boolean isTargetClass = false;
    private String targetMethod;

    public ViewOnClickClassAdapter(ClassVisitor cv) {
        super(cv);
        this.className = ON_CLICK_LISTENER_INTERFACE_NAME;
        Method method = Method.getMethod(READABLE_TARGET_METHOD);
        this.targetMethod = method.getName() + method.getDescriptor();
    }

    private boolean shouldInstrumentMethod(String methodName, String methodDesc) {
        return this.targetMethod.equals(methodName + methodDesc);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.isTargetClass = false;
        if (interfaces != null) {
            for (String interf : interfaces) {
                if (!interf.equals(ON_CLICK_LISTENER_INTERFACE_NAME)) continue;
                this.isTargetClass = true;
                this.logger.debug("Found an implementation of %s interface: %s", ON_CLICK_LISTENER_INTERFACE_NAME, this.className);
                BCIRunSummary.getDefaultInstance().featureInjected("UI_EVENT", this.className);
                break;
            }
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
        MethodVisitor baseMV = super.visitMethod(access, methodName, methodDesc, signature, exceptions);
        if (this.isTargetClass && this.shouldInstrumentMethod(methodName, methodDesc)) {
            return new OnClickMethodVisitor(baseMV, access, methodName, methodDesc);
        }
        return baseMV;
    }

    private class OnClickMethodVisitor
    extends BaseClassVisitor.BaseMethodVisitor {
        OnClickMethodVisitor(MethodVisitor mv, int access, String methodName, String methodDesc) {
            super(mv, access, methodName, methodDesc);
        }

        @Override
        public void visitCode() {
            this.mv.visitVarInsn(25, 1);
            this.mv.visitLdcInsn(ViewOnClickClassAdapter.this.className);
            this.mv.visitMethodInsn(184, "com/appdynamics/eumagent/runtime/InstrumentationCallbacks", "onViewClicked", "(Landroid/view/View;Ljava/lang/String;)V");
            this.mv.visitCode();
        }
    }
}

