/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.eumagent.runtime.networkrequests;

import com.appdynamics.eumagent.runtime.HttpRequestTracker;
import com.appdynamics.eumagent.runtime.Instrumentation;
import com.appdynamics.eumagent.runtime.InstrumentationCallbacks;
import com.appdynamics.eumagent.runtime.ServerCorrelationHeaders;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttp3 {
    public static final String OKHTTP3_INSTRUMENTATION_SOURCE = "AppDynamics.OkHttp3Client";
    private static final ThreadLocal<HttpRequestTracker> threadLocalTracker = new ThreadLocal();

    private static HttpRequestTracker startNewTracker(okhttp3.Request request) {
        HttpRequestTracker tracker;
        if (threadLocalTracker.get() != null) {
            return null;
        }
        try {
            HttpUrl url = request.url();
            if (url == null) {
                return null;
            }
            tracker = Instrumentation.beginHttpRequest((URL)url.url());
            tracker.withInstrumentationSource(OKHTTP3_INSTRUMENTATION_SOURCE);
            threadLocalTracker.set(tracker);
        }
        catch (Throwable e) {
            InstrumentationCallbacks.safeLog((String)"Trying to obtain URL to create tracker.", (Throwable)e);
            return null;
        }
        try {
            Map multiMap = request.headers().toMultimap();
            tracker.withRequestHeaderFields(multiMap);
        }
        catch (Throwable e) {
            InstrumentationCallbacks.safeLog((String)"Trying to transfer headers to tracker.", (Throwable)e);
        }
        return tracker;
    }

    private static void reportDone(HttpRequestTracker tracker, Response response) {
        if (tracker == null) {
            return;
        }
        threadLocalTracker.remove();
        if (response == null) {
            return;
        }
        int responseCode = response.code();
        String statusMessage = null;
        if (responseCode >= 400) {
            statusMessage = response.message();
        }
        tracker.withStatusLine(statusMessage).withResponseCode(responseCode);
        Map multiMap = response.headers().toMultimap();
        tracker.withResponseHeaderFields(multiMap).reportDone();
    }

    private static void reportException(HttpRequestTracker tracker, IOException e) {
        if (tracker == null) {
            return;
        }
        threadLocalTracker.remove();
        tracker.withException((Exception)e).reportDone();
    }

    public static class RealInterceptorChain {

        public static class proceed {
            public static Object Enter(Object object, Object requestObject, Object o2, Object o3, Object o4) {
                try {
                    okhttp3.Request request = (okhttp3.Request)requestObject;
                    return OkHttp3.startNewTracker(request);
                }
                catch (Throwable e) {
                    InstrumentationCallbacks.safeLog((String)"Trying to get tracker.", (Throwable)e);
                    return null;
                }
            }

            public static void Exit(Object object, Object returnedObject, Object scratchObject, Object requestObject, Object o2, Object o3, Object o4) {
                try {
                    HttpRequestTracker tracker = (HttpRequestTracker)scratchObject;
                    Response response = (Response)returnedObject;
                    OkHttp3.reportDone(tracker, response);
                }
                catch (Throwable e) {
                    InstrumentationCallbacks.safeLog((String)"Trying to report tracker.", (Throwable)e);
                }
            }

            public static void ThrowMe(Object object, Object scratchObject, IOException e) {
                try {
                    HttpRequestTracker tracker = (HttpRequestTracker)scratchObject;
                    OkHttp3.reportException(tracker, e);
                }
                catch (Throwable e1) {
                    InstrumentationCallbacks.safeLog((String)"Trying to report exception.", (Throwable)e1);
                }
            }
        }
    }

    public static class RealCall {

        public static class getResponse {
            public static Object Enter(Object object, Object requestObject, boolean b) {
                try {
                    okhttp3.Request request = (okhttp3.Request)requestObject;
                    return OkHttp3.startNewTracker(request);
                }
                catch (Throwable e) {
                    InstrumentationCallbacks.safeLog((String)"Trying to get tracker.", (Throwable)e);
                    return null;
                }
            }

            public static void Exit(Object object, Object returnedObject, Object scratchObject, Object requestObject, boolean b) {
                try {
                    HttpRequestTracker tracker = (HttpRequestTracker)scratchObject;
                    Response response = (Response)returnedObject;
                    OkHttp3.reportDone(tracker, response);
                }
                catch (Throwable e) {
                    InstrumentationCallbacks.safeLog((String)"Trying to report tracker.", (Throwable)e);
                }
            }

            public static void ThrowMe(Object object, Object scratchObject, IOException e) {
                try {
                    HttpRequestTracker tracker = (HttpRequestTracker)scratchObject;
                    OkHttp3.reportException(tracker, e);
                }
                catch (Throwable e1) {
                    InstrumentationCallbacks.safeLog((String)"Trying to report exception.", (Throwable)e1);
                }
            }
        }
    }

    public static class Request {

        public static class Builder {

            public static class build {
                public static Object Enter(Object object) {
                    try {
                        Request.Builder builder = (Request.Builder)object;
                        Map headers = ServerCorrelationHeaders.generate();
                        for (Map.Entry header : headers.entrySet()) {
                            for (String value : (List)header.getValue()) {
                                builder.header((String)header.getKey(), value);
                            }
                        }
                    }
                    catch (Throwable e) {
                        InstrumentationCallbacks.safeLog((String)"Trying to add correlation headers.", (Throwable)e);
                    }
                    return null;
                }

                public static void Exit(Object object, Object returnedObject, Object scratchObject) {
                    try {
                        HttpRequestTracker tracker = (HttpRequestTracker)threadLocalTracker.get();
                        if (tracker == null) {
                            return;
                        }
                        okhttp3.Request request = (okhttp3.Request)returnedObject;
                        Map multimap = request.headers().toMultimap();
                        tracker.withRequestHeaderFields(multimap);
                    }
                    catch (Throwable e) {
                        InstrumentationCallbacks.safeLog((String)"Trying to add request headers.", (Throwable)e);
                    }
                }
            }
        }
    }
}

