/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci;

import com.appdynamics.android.StopInstrumentationException;
import com.appdynamics.android.bci.ClassUtil;
import com.appdynamics.android.bci.CompositeAdapterFactory;
import com.appdynamics.android.bci.InjectorConfig;
import com.appdynamics.android.bci.LoadingClassWriter;
import com.appdynamics.android.logging.BCILogger;
import com.appdynamics.android.logging.BCIRunSummary;
import com.appdynamics.android.util.BuildUtils;
import com.appdynamics.repackaged.asm.ClassReader;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.ClassWriter;
import com.appdynamics.repackaged.asm.util.CheckClassAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;

public class ClassStreamRewriter {
    private static final String UNABLE_TO_DETERMINE_CLASS_NAME = "Unable to determine class name";
    private static final BCILogger logger = BCILogger.getLoggerFor(ClassStreamRewriter.class);
    private ClassWriter cw;
    private boolean failed = false;
    private boolean isRuntimeClass = false;
    private boolean isExcludedClass = false;
    private byte[] inputCopy;
    private final CompositeAdapterFactory factory;
    private final InjectorConfig config;
    private final ClassUtil classUtil;

    public ClassStreamRewriter(CompositeAdapterFactory factory, InjectorConfig config, ClassUtil classUtil) {
        this.factory = factory;
        this.config = config;
        this.classUtil = classUtil;
    }

    public void readInput(InputStream in) throws IOException {
        this.failed = false;
        this.inputCopy = BuildUtils.copyStream(in).toByteArray();
        try {
            ClassReader cr = new ClassReader(this.inputCopy);
            String className = cr.getClassName();
            boolean bl = this.isRuntimeClass = className.startsWith("com/appdynamics/eumagent/runtime") || className.startsWith("com/appdynamics/repacked");
            if (this.isRuntimeClass) {
                logger.info("Skipping %s because its part of runtime agent", cr.getClassName());
                return;
            }
            this.isExcludedClass = false;
            for (Pattern pat : this.config.getExclusionPatterns()) {
                if (!pat.matcher(className).matches()) continue;
                this.isExcludedClass = true;
                logger.info("Skipping %s because it is in the exclusion list", className);
                return;
            }
            logger.debug("Processing: %s", cr.getClassName());
            BCIRunSummary.getDefaultInstance().incrementClassCount();
            this.cw = new LoadingClassWriter(this.classUtil);
            ClassVisitor cv = this.factory.createAdapter(this.cw);
            CheckClassAdapter cca = new CheckClassAdapter(cv);
            cr.accept(cca, 8);
        }
        catch (StopInstrumentationException ex) {
            throw ex;
        }
        catch (Throwable throwable) {
            String className = this.getClassName();
            if (!UNABLE_TO_DETERMINE_CLASS_NAME.equals(className)) {
                BCIRunSummary.getDefaultInstance().failedToInstrumentClass(className);
            }
            this.failed = true;
            logger.error(throwable, "Unable to process [%s] for instrumentation.", className);
        }
    }

    private String getClassName() {
        try {
            return new ClassReader(this.inputCopy).getClassName();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            return UNABLE_TO_DETERMINE_CLASS_NAME;
        }
    }

    public void writeOutput(OutputStream out) throws IOException {
        if (this.failed || this.isRuntimeClass || this.isExcludedClass) {
            try {
                out.write(this.inputCopy);
            }
            finally {
                this.inputCopy = null;
            }
        } else {
            out.write(this.cw.toByteArray());
        }
        this.cw = null;
    }
}

