/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci;

import com.appdynamics.android.bci.ActivityLifecycleAdapter;
import com.appdynamics.android.bci.BuildIdInjector;
import com.appdynamics.android.bci.BuildInfoInjector;
import com.appdynamics.android.bci.ClassStreamRewriter;
import com.appdynamics.android.bci.ClassUtil;
import com.appdynamics.android.bci.CompositeAdapterFactory;
import com.appdynamics.android.bci.FragmentLifecycleAdapter;
import com.appdynamics.android.bci.IAdapterFactory;
import com.appdynamics.android.bci.InjectorConfig;
import com.appdynamics.android.bci.ManualInfoPointAdapter;
import com.appdynamics.android.bci.NetworkConnectionHarvestMarker;
import com.appdynamics.android.bci.OpaqueCallbackInjector;
import com.appdynamics.android.bci.OpaqueClassVisitor;
import com.appdynamics.android.bci.OpaqueInterceptor;
import com.appdynamics.android.bci.PreprocessAdapter;
import com.appdynamics.android.bci.SetOnClickListenerTrackingAdapterFactory;
import com.appdynamics.android.bci.SetOnFocusChangeListenerTrackingAdapterFactory;
import com.appdynamics.android.bci.SetOnHierarchyChangeListenerTrackingAdapterFactory;
import com.appdynamics.android.bci.SetOnItemClickListenerTrackingAdapterFactory;
import com.appdynamics.android.bci.VersionLoader;
import com.appdynamics.android.bci.WebChromeClientAdapterFactory;
import com.appdynamics.android.bci.WebViewClientAdapterFactory;
import com.appdynamics.android.bci.adapters.AddJSCallbackAdapter;
import com.appdynamics.android.bci.adapters.JSInjectionAdapter;
import com.appdynamics.android.bci.features.NetworkConnectionTracking;
import com.appdynamics.android.bci.features.OpaqueClassTracking;
import com.appdynamics.android.bci.io.ClassFileRewriter;
import com.appdynamics.android.bci.io.IStreamFactory;
import com.appdynamics.android.bci.io.JarFileRewriter;
import com.appdynamics.android.bci.io.StreamFactory;
import com.appdynamics.android.logging.BCILogger;
import com.appdynamics.android.logging.BCIRunSummary;
import com.appdynamics.android.util.BuildUtils;
import com.appdynamics.repackaged.asm.ClassVisitor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.UUID;

public class Injector {
    private static final BCILogger logger = BCILogger.getLoggerFor(Injector.class);
    private final CompositeAdapterFactory adapterFactory;
    private final InjectorConfig config;
    private final BuildInfoInjector buildInfoInjector;
    private final OpaqueCallbackInjector opaqueCallbackInjector;
    private final ClassStreamRewriter streamRewriter;
    private final IStreamFactory streamFactory;
    private final String injectorVersion = new VersionLoader().loadVersion();
    private final String buildId;

    private static void usage(String msg) {
        String prog = System.getProperty("sun.java.command");
        System.err.println(prog + ": " + msg);
        System.err.println("usage: java -jar injector.jar <path> [options] [optional libraries...]");
        System.err.println("  options:");
        System.err.println("    -i <file>                    : YML file describing interceptor, can be used multiple times");
        System.err.println("    -x <pattern>                 : Classes to be excluded from injection, can be used multiple times");
        System.err.println("    --enableWebViewCrashReporting: Instrument crash reporting for WebView objects");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            Injector.usage("no arguments?");
        } else {
            File logFileDir = new File(System.getProperty("java.io.tmpdir"), "Appd-androidbci_" + System.currentTimeMillis());
            logFileDir.mkdirs();
            BCILogger.setBciLogger(new BCILogger.MultiLogger(logFileDir){

                @Override
                protected void _log(BCILogger.Level level, String msg) {
                    if (level == BCILogger.Level.INFO) {
                        System.out.println("[INFO] " + msg);
                    }
                }
            });
            System.out.println("Logs are available at: " + logFileDir);
            InjectorConfig config = new InjectorConfig();
            ArrayList<URL> urls = new ArrayList<URL>();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-i")) {
                    if (++i >= args.length) {
                        Injector.usage("-i: requires argument");
                        return;
                    }
                    config.addInterceptorFiles(args[i]);
                    continue;
                }
                if (args[i].equals("-x")) {
                    if (++i >= args.length) {
                        Injector.usage("-x: requires argument");
                        return;
                    }
                    config.addExcludedClasses(args[i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("--enableWebViewCrashReporting")) {
                    config.setWebViewCallbackCrashReportingEnabled(true);
                    continue;
                }
                urls.add(new File(args[i]).toURI().toURL());
            }
            ClassUtil classUtil = ClassUtil.Factory.createClassUtil(urls.toArray(new URL[0]));
            Injector injector = new Injector(classUtil, config);
            injector.printStartSummary();
            File rootFolder = new File(args[0]);
            if (!rootFolder.isDirectory()) {
                Injector.usage(String.format("path: is not a directory: %s", args[0]));
                return;
            }
            try {
                injector.instrumentClassFiles(rootFolder);
            }
            finally {
                injector.writeExtraClassesIntoDirectory(rootFolder);
                injector.printRunSummary();
            }
        }
    }

    public Injector(ClassUtil classUtil, InjectorConfig config) {
        if (config == null) {
            config = new InjectorConfig();
        }
        this.config = config;
        this.streamFactory = new StreamFactory();
        logger.debug("Initializing ClassStreamRewriter.", new Object[0]);
        logger.info("Injector version = " + this.injectorVersion, new Object[0]);
        logger.debug("Using config = %s", config);
        this.buildId = UUID.randomUUID().toString();
        this.buildInfoInjector = new BuildInfoInjector(this.buildId);
        this.opaqueCallbackInjector = new OpaqueCallbackInjector();
        this.adapterFactory = new CompositeAdapterFactory();
        this.adapterFactory.addAdapter(new IAdapterFactory(){

            @Override
            public ClassVisitor createAdapter(ClassVisitor delegate) {
                return new PreprocessAdapter(delegate);
            }
        });
        for (NetworkConnectionTracking.MethodInterceptionInfo methodInterceptionInfo : NetworkConnectionTracking.METHODS_TO_INTERCEPT) {
            this.adapterFactory.addAdapter(NetworkConnectionTracking.timeMethodAdapterFactory(methodInterceptionInfo.method, methodInterceptionInfo.exceptionToCatch));
        }
        for (NetworkConnectionTracking.MethodSubstitutionInfo methodSubstitutionInfo : NetworkConnectionTracking.METHODS_TO_REPLACE) {
            this.adapterFactory.addAdapter(NetworkConnectionTracking.replaceMethodCallAdapterFactory(methodSubstitutionInfo.methodToReplace, methodSubstitutionInfo.originalSignature, methodSubstitutionInfo.methodToCall, methodSubstitutionInfo.newSignature, methodSubstitutionInfo.featureInjected));
        }
        for (String string : config.getInterceptorFiles()) {
            for (OpaqueClassVisitor.ClassInfo i : OpaqueInterceptor.getInterceptors(string)) {
                this.adapterFactory.addAdapter(OpaqueClassTracking.opaqueMethodVistor(this.opaqueCallbackInjector, i));
            }
        }
        this.adapterFactory.addAdapter(new ActivityLifecycleAdapter.Factory(classUtil));
        this.adapterFactory.addAdapter(new FragmentLifecycleAdapter.Factory(classUtil));
        this.adapterFactory.addAdapter(new NetworkConnectionHarvestMarker.Factory());
        this.adapterFactory.addAdapter(new SetOnHierarchyChangeListenerTrackingAdapterFactory(classUtil));
        this.adapterFactory.addAdapter(new SetOnClickListenerTrackingAdapterFactory(classUtil));
        this.adapterFactory.addAdapter(new SetOnFocusChangeListenerTrackingAdapterFactory(classUtil));
        this.adapterFactory.addAdapter(new SetOnItemClickListenerTrackingAdapterFactory(classUtil));
        this.adapterFactory.addAdapter(new AddJSCallbackAdapter.Factory(classUtil));
        this.adapterFactory.addAdapter(new JSInjectionAdapter.Factory(classUtil));
        this.adapterFactory.addAdapter(new ManualInfoPointAdapter.Factory());
        if (config.isWebViewCallbackCrashReportingEnabled()) {
            this.adapterFactory.addAdapter(new WebViewClientAdapterFactory(classUtil));
            this.adapterFactory.addAdapter(new WebChromeClientAdapterFactory(classUtil));
        }
        this.adapterFactory.addAdapter(new BuildIdInjector.Factory(classUtil, this.buildId));
        this.streamRewriter = new ClassStreamRewriter(this.adapterFactory, config, classUtil);
    }

    public void writeExtraClassesIntoDirectory(File classesDirectory) {
        try {
            this.buildInfoInjector.writeBuildInfoClass(classesDirectory);
            this.opaqueCallbackInjector.writeOpaqueCallbacks(classesDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void printStartSummary() {
        BCILogger.getBciLogger().info("\n\n\t\t\t%s\n\n", BuildUtils.encloseInBanner("Starting AppDynamics BCI Instrumentation", '=').replaceAll("\n", "\n\t\t\t"));
    }

    public void instrumentJar(File outJarFile, File inJarFile) throws IOException {
        JarFileRewriter jarFileRewriter = new JarFileRewriter(outJarFile, inJarFile, this.streamRewriter, this.streamFactory);
        jarFileRewriter.rewrite();
    }

    public void instrumentClassFiles(File directory) throws IOException {
        ClassFileRewriter classFilesRewriter = new ClassFileRewriter(directory, this.streamRewriter, this.streamFactory);
        classFilesRewriter.rewrite();
    }

    public void printRunSummary() {
        BCIRunSummary.getDefaultInstance().printSummary();
    }

    public String getBuildId() {
        return this.buildId;
    }
}

