/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.features;

import com.appdynamics.android.bci.IAdapterFactory;
import com.appdynamics.android.bci.QName;
import com.appdynamics.android.bci.ReplaceMethodCallAdapter;
import com.appdynamics.android.bci.TimeMethodAdapter;
import com.appdynamics.android.bci.signature.AMethodSignatureChangePolicy;
import com.appdynamics.android.bci.signature.MethodSignatureBuilder;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.Type;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class NetworkConnectionTracking {
    private static final String URL_CONNECTION = "java/net/URLConnection";
    private static final String HTTP_URL_CONNECTION = "java/net/HttpURLConnection";
    private static final String HTTPS_URL_CONNECTION = "javax/net/ssl/HttpsURLConnection";
    private static final String IO_EXCEPTION = "java/io/IOException";
    public static final List<MethodInterceptionInfo> METHODS_TO_INTERCEPT = new ArrayList<MethodInterceptionInfo>();
    private static final String URL_CONNECTION_GET_INPUT_STREAM_ORIGINAL_SIGNATURE = "()Ljava/io/InputStream;";
    private static final String URL_CONNECTION_GET_INPUT_STREAM_SIGNATURE = "(Ljava/net/URLConnection;)Ljava/io/InputStream;";
    private static final String HTTP_URL_CONNECTION_GET_ERROR_STREAM_SIGNATURE = "(Ljava/net/HttpURLConnection;)Ljava/io/InputStream;";
    private static final String EUMAGENT_INSTRUMENTATION = "com/appdynamics/eumagent/runtime/InstrumentationCallbacks";
    private static final String HTTP_CLIENT = "org/apache/http/client/HttpClient";
    private static final String ABSTRACT_HTTP_CLIENT = "org/apache/http/impl/client/AbstractHttpClient";
    private static final String ANDROID_HTTP_CLIENT = "android/net/http/AndroidHttpClient";
    private static final String DEFAULT_HTTP_CLIENT = "org/apache/http/impl/client/DefaultHttpClient";
    private static final String HTTP_URI_REQUEST = "org/apache/http/client/methods/HttpUriRequest";
    private static final String HTTP_REQUEST = "org/apache/http/HttpRequest";
    private static final String HTTP_CONTEXT = "org/apache/http/protocol/HttpContext";
    private static final String HTTP_RESPONSE_HANDLER = "org/apache/http/client/ResponseHandler";
    private static final String HTTP_HOST = "org/apache/http/HttpHost";
    private static final String HTTP_RESPONSE = "org/apache/http/HttpResponse";
    private static final String OBJECT = "java/lang/Object";
    private static final List<String> HTTP_CLIENTS;
    private static final List<MethodSignatureBuilder> HTTP_CLIENT_SIGNATURES;
    private static final AMethodSignatureChangePolicy HTTP_CLIENT_SIGNATURE_POLICY;
    public static final List<MethodSubstitutionInfo> METHODS_TO_REPLACE;

    private static MethodSignatureBuilder getSignature(String returnType, String ... args) {
        ArrayList<Type> argTypes = new ArrayList<Type>();
        for (String arg : args) {
            argTypes.add(Type.getObjectType(arg));
        }
        return new MethodSignatureBuilder(argTypes, Type.getObjectType(returnType));
    }

    private static void addAllMethods(String src, String dest) {
        LinkedList<MethodInterceptionInfo> toAdd = new LinkedList<MethodInterceptionInfo>();
        for (MethodInterceptionInfo info : METHODS_TO_INTERCEPT) {
            if (!info.method.owner.equals(src)) continue;
            toAdd.add(new MethodInterceptionInfo(dest, info.method.name, info.exceptionToCatch));
        }
        METHODS_TO_INTERCEPT.addAll(toAdd);
    }

    public static IAdapterFactory timeMethodAdapterFactory(final QName method, final String exceptionToCatch) {
        return new IAdapterFactory(){

            @Override
            public ClassVisitor createAdapter(ClassVisitor delegate) {
                return new TimeMethodAdapter(method, exceptionToCatch, delegate);
            }
        };
    }

    public static IAdapterFactory replaceMethodCallAdapterFactory(final QName method, final String origSig, final QName methodToCall, final String sig, final String feature) {
        return new IAdapterFactory(){

            @Override
            public ClassVisitor createAdapter(ClassVisitor delegate) {
                return new ReplaceMethodCallAdapter(method, origSig, methodToCall, sig, delegate, feature);
            }
        };
    }

    static {
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "connect", IO_EXCEPTION));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getContent", IO_EXCEPTION));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getContentEncoding"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getContentLength"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getContentType"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getDate"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getExpiration"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getLastModified"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getHeaderFieldDate"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getHeaderFields"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getHeaderFieldKey"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getHeaderField"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getHeaderFieldInt"));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(URL_CONNECTION, "getOutputStream", IO_EXCEPTION));
        NetworkConnectionTracking.addAllMethods(URL_CONNECTION, HTTP_URL_CONNECTION);
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(HTTP_URL_CONNECTION, "getResponseMessage", IO_EXCEPTION));
        METHODS_TO_INTERCEPT.add(new MethodInterceptionInfo(HTTP_URL_CONNECTION, "getResponseCode", IO_EXCEPTION));
        NetworkConnectionTracking.addAllMethods(HTTP_URL_CONNECTION, HTTPS_URL_CONNECTION);
        HTTP_CLIENTS = new ArrayList<String>();
        HTTP_CLIENTS.add(HTTP_CLIENT);
        HTTP_CLIENTS.add(ABSTRACT_HTTP_CLIENT);
        HTTP_CLIENTS.add(ANDROID_HTTP_CLIENT);
        HTTP_CLIENTS.add(DEFAULT_HTTP_CLIENT);
        HTTP_CLIENT_SIGNATURES = new ArrayList<MethodSignatureBuilder>();
        HTTP_CLIENT_SIGNATURE_POLICY = AMethodSignatureChangePolicy.prependArgumentOfType(Type.getObjectType(HTTP_CLIENT));
        HTTP_CLIENT_SIGNATURES.add(NetworkConnectionTracking.getSignature(HTTP_RESPONSE, HTTP_URI_REQUEST));
        HTTP_CLIENT_SIGNATURES.add(NetworkConnectionTracking.getSignature(HTTP_RESPONSE, HTTP_URI_REQUEST, HTTP_CONTEXT));
        HTTP_CLIENT_SIGNATURES.add(NetworkConnectionTracking.getSignature(HTTP_RESPONSE, HTTP_HOST, HTTP_REQUEST));
        HTTP_CLIENT_SIGNATURES.add(NetworkConnectionTracking.getSignature(HTTP_RESPONSE, HTTP_HOST, HTTP_REQUEST, HTTP_CONTEXT));
        HTTP_CLIENT_SIGNATURES.add(NetworkConnectionTracking.getSignature(OBJECT, HTTP_URI_REQUEST, HTTP_RESPONSE_HANDLER));
        HTTP_CLIENT_SIGNATURES.add(NetworkConnectionTracking.getSignature(OBJECT, HTTP_URI_REQUEST, HTTP_RESPONSE_HANDLER, HTTP_CONTEXT));
        HTTP_CLIENT_SIGNATURES.add(NetworkConnectionTracking.getSignature(OBJECT, HTTP_HOST, HTTP_REQUEST, HTTP_RESPONSE_HANDLER));
        HTTP_CLIENT_SIGNATURES.add(NetworkConnectionTracking.getSignature(OBJECT, HTTP_HOST, HTTP_REQUEST, HTTP_RESPONSE_HANDLER, HTTP_CONTEXT));
        METHODS_TO_REPLACE = new ArrayList<MethodSubstitutionInfo>();
        METHODS_TO_REPLACE.add(new MethodSubstitutionInfo(new QName(URL_CONNECTION, "getInputStream"), URL_CONNECTION_GET_INPUT_STREAM_ORIGINAL_SIGNATURE, new QName(EUMAGENT_INSTRUMENTATION, "getInputStream"), URL_CONNECTION_GET_INPUT_STREAM_SIGNATURE, "URL_HTTP"));
        METHODS_TO_REPLACE.add(new MethodSubstitutionInfo(new QName(HTTP_URL_CONNECTION, "getInputStream"), URL_CONNECTION_GET_INPUT_STREAM_ORIGINAL_SIGNATURE, new QName(EUMAGENT_INSTRUMENTATION, "getInputStream"), URL_CONNECTION_GET_INPUT_STREAM_SIGNATURE, "URL_HTTP"));
        METHODS_TO_REPLACE.add(new MethodSubstitutionInfo(new QName(HTTPS_URL_CONNECTION, "getInputStream"), URL_CONNECTION_GET_INPUT_STREAM_ORIGINAL_SIGNATURE, new QName(EUMAGENT_INSTRUMENTATION, "getInputStream"), URL_CONNECTION_GET_INPUT_STREAM_SIGNATURE, "URL_HTTP"));
        METHODS_TO_REPLACE.add(new MethodSubstitutionInfo(new QName(HTTP_URL_CONNECTION, "getErrorStream"), URL_CONNECTION_GET_INPUT_STREAM_ORIGINAL_SIGNATURE, new QName(EUMAGENT_INSTRUMENTATION, "getErrorStream"), HTTP_URL_CONNECTION_GET_ERROR_STREAM_SIGNATURE, "URL_HTTP"));
        METHODS_TO_REPLACE.add(new MethodSubstitutionInfo(new QName(HTTPS_URL_CONNECTION, "getErrorStream"), URL_CONNECTION_GET_INPUT_STREAM_ORIGINAL_SIGNATURE, new QName(EUMAGENT_INSTRUMENTATION, "getErrorStream"), HTTP_URL_CONNECTION_GET_ERROR_STREAM_SIGNATURE, "URL_HTTP"));
        for (String client : HTTP_CLIENTS) {
            for (MethodSignatureBuilder origSig : HTTP_CLIENT_SIGNATURES) {
                METHODS_TO_REPLACE.add(new MethodSubstitutionInfo(new QName(client, "execute"), origSig.toString(), new QName(EUMAGENT_INSTRUMENTATION, "execute"), HTTP_CLIENT_SIGNATURE_POLICY.apply(origSig).toString(), "APACHE_HTTP"));
            }
        }
    }

    public static class MethodSubstitutionInfo {
        public final QName methodToReplace;
        public final String originalSignature;
        public final QName methodToCall;
        public final String newSignature;
        public final String featureInjected;

        MethodSubstitutionInfo(QName methodToReplace, String originalSignature, QName methodToCall, String newSignature, String featureInjected) {
            this.methodToReplace = methodToReplace;
            this.originalSignature = originalSignature;
            this.methodToCall = methodToCall;
            this.newSignature = newSignature;
            this.featureInjected = featureInjected;
        }
    }

    public static class MethodInterceptionInfo {
        public final QName method;
        public final String exceptionToCatch;

        MethodInterceptionInfo(String clazz, String method, String exceptionToCatch) {
            this.method = new QName(clazz, method);
            this.exceptionToCatch = exceptionToCatch;
        }

        MethodInterceptionInfo(String clazz, String method) {
            this(clazz, method, null);
        }
    }
}

