/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.bytecodeinjectors;

import com.appdynamics.android.bci.bytecodeinjectors.BaseClassVisitor;
import com.appdynamics.android.bci.bytecodeinjectors.config.MethodCallMatcher;
import com.appdynamics.android.bci.util.ExceptionHandler;
import com.appdynamics.android.logging.BCIRunSummary;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.Label;
import com.appdynamics.repackaged.asm.MethodVisitor;
import com.appdynamics.repackaged.asm.Type;
import com.appdynamics.repackaged.asm.commons.Method;
import java.util.ArrayList;
import java.util.List;

public class WrapMethodCallInjector
extends BaseClassVisitor {
    private static final String THROWABLE_CLASS = "java/lang/Throwable";
    private final String feature;
    private final MethodCallMatcher methodCallMatcher;
    private final Method beforeMethod;
    private final Method afterMethod;
    private final Method threwMethod;
    private final String exceptionClass;
    private final boolean ignoreArgs;

    public WrapMethodCallInjector(ClassVisitor cv, String feature, MethodCallMatcher methodCallMatcher, Method beforeMethod, Method afterMethod, Method threwMethod, String exceptionClass, boolean ignoreArgs) {
        super(cv);
        this.feature = feature;
        this.methodCallMatcher = methodCallMatcher;
        this.beforeMethod = beforeMethod;
        this.afterMethod = afterMethod;
        this.threwMethod = threwMethod;
        this.exceptionClass = exceptionClass;
        this.ignoreArgs = ignoreArgs;
    }

    @Override
    public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
        MethodVisitor baseMV = super.visitMethod(access, methodName, methodDesc, signature, exceptions);
        return new BeforeAfterMethodVisitor(baseMV, access, methodName, methodDesc);
    }

    private class BeforeAfterMethodVisitor
    extends BaseClassVisitor.BaseMethodVisitor {
        private List<ExceptionHandler> exceptionHandlers;

        BeforeAfterMethodVisitor(MethodVisitor mv, int access, String methodName, String methodDesc) {
            super(mv, access, methodName, methodDesc);
            this.exceptionHandlers = new ArrayList<ExceptionHandler>();
        }

        @Override
        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            this.exceptionHandlers.add(new ExceptionHandler(start, end, handler, type));
        }

        @Override
        public void visitCode() {
            this.exceptionHandlers.clear();
            super.visitCode();
        }

        @Override
        public void visitEnd() {
            for (ExceptionHandler handler : this.exceptionHandlers) {
                super.visitTryCatchBlock(handler.start, handler.end, handler.handler, handler.type);
            }
            super.visitEnd();
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (WrapMethodCallInjector.this.methodCallMatcher.isMethodCallMatched(owner, name, desc)) {
                int ownerLocal;
                BCIRunSummary.getDefaultInstance().featureInjected(WrapMethodCallInjector.this.feature, WrapMethodCallInjector.this.className);
                WrapMethodCallInjector.this.logInjectedWithLineNumber("Instrumenting method call: %s%s", this.methodName, this.methodDesc);
                Method method = new Method(name, desc);
                Label tryStartLabel = new Label();
                Label tryEndLabel = new Label();
                Label catchEndLabel = new Label();
                Type ownerType = Type.getObjectType(owner);
                if (WrapMethodCallInjector.this.beforeMethod != null) {
                    ownerLocal = WrapMethodCallInjector.this.ignoreArgs ? this.dupOwnerOnly(ownerType, method) : this.dupOwnerAndArgs(ownerType, method);
                    this.instrumentationCallback(WrapMethodCallInjector.this.beforeMethod);
                } else {
                    ownerLocal = this.dupOwnerOnly(ownerType, method);
                    this.pop();
                }
                if (WrapMethodCallInjector.this.threwMethod != null) {
                    this.mv.visitLabel(tryStartLabel);
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
                if (WrapMethodCallInjector.this.afterMethod != null) {
                    if (WrapMethodCallInjector.this.ignoreArgs || method.getReturnType() == Type.VOID_TYPE) {
                        this.loadLocal(ownerLocal);
                    } else {
                        int returnLocal = this.storeTopOfStack(method.getReturnType());
                        this.loadLocal(ownerLocal, ownerType);
                        this.loadLocal(returnLocal, method.getReturnType());
                    }
                    this.instrumentationCallback(WrapMethodCallInjector.this.afterMethod);
                }
                if (WrapMethodCallInjector.this.threwMethod != null) {
                    super.visitJumpInsn(167, catchEndLabel);
                    this.mv.visitLabel(tryEndLabel);
                    super.visitInsn(89);
                    this.loadLocal(ownerLocal, ownerType);
                    super.visitInsn(95);
                    this.instrumentationCallback(WrapMethodCallInjector.this.threwMethod);
                    this.mv.visitInsn(191);
                    super.visitLabel(catchEndLabel);
                    super.visitTryCatchBlock(tryStartLabel, tryEndLabel, tryEndLabel, WrapMethodCallInjector.this.exceptionClass);
                }
                BCIRunSummary.getDefaultInstance().featureInjected(WrapMethodCallInjector.this.feature, WrapMethodCallInjector.this.className);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }
}

