/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.features;

import com.appdynamics.android.bci.bytecodeinjectors.ReplaceMethodCallInjector;
import com.appdynamics.android.bci.bytecodeinjectors.WrapMethodCallInjector;
import com.appdynamics.android.bci.bytecodeinjectors.config.MethodCallMatcher;
import com.appdynamics.android.bci.features.ClassVisitorFactory;
import com.appdynamics.android.bci.util.ClassUtil;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.commons.Method;

public class URLConnectionTracking
implements ClassVisitorFactory {
    private static final String FEATURE = "URL_HTTP";
    private static final String URL_CONNECTION = "java/net/URLConnection";
    private static final String HTTP_URL_CONNECTION = "java/net/HttpURLConnection";
    private static final String HTTPS_URL_CONNECTION = "javax/net/ssl/HttpsURLConnection";
    private static final String IO_EXCEPTION = "java/io/IOException";
    private static final String[] URL_CONNECTION_CLASSES = new String[]{"java/net/URLConnection", "java/net/HttpURLConnection", "javax/net/ssl/HttpsURLConnection"};
    private static final Method[] METHODS_THAT_CONNECT_AND_READ_BYTES = new Method[]{Method.getMethod("java.lang.Object getContent()"), Method.getMethod("java.lang.Object getContent(Class[])"), Method.getMethod("java.lang.String getContentEncoding()"), Method.getMethod("int getContentLength()"), Method.getMethod("java.lang.String getContentType()"), Method.getMethod("long getDate()"), Method.getMethod("long getExpiration()"), Method.getMethod("long getLastModified()"), Method.getMethod("long getHeaderFieldDate(java.lang.String, long)"), Method.getMethod("java.util.Map getHeaderFields()"), Method.getMethod("java.lang.String getHeaderFieldKey(int)"), Method.getMethod("java.lang.String getHeaderField(int)"), Method.getMethod("java.lang.String getHeaderField(java.lang.String)"), Method.getMethod("int getHeaderFieldInt(java.lang.String, int)"), Method.getMethod("java.lang.String getResponseMessage()"), Method.getMethod("int getResponseCode()")};
    private static final Method[] METHODS_THAT_WOULD_TRIGGER_REQUEST = new Method[]{Method.getMethod("void connect()"), Method.getMethod("java.io.OutputStream getOutputStream()")};
    private static final Method GET_INPUT_STREAM = Method.getMethod("java.io.InputStream getInputStream()");
    private static final Method GET_ERROR_STREAM = Method.getMethod("java.io.InputStream getErrorStream()");
    private static final Method REQUEST_ABOUT_TO_BE_SENT = Method.getMethod("void requestAboutToBeSent(java.net.URLConnection)");
    private static final Method REQUEST_SENT = Method.getMethod("void requestSent(java.net.URLConnection)");
    private static final Method REQUEST_HARVESTABLE = Method.getMethod("void requestHarvestable(java.net.URLConnection)");
    private static final Method NETWORK_ERROR = Method.getMethod("void networkError(java.net.URLConnection, java.io.IOException)");
    private static final Method GET_INPUT_STREAM_CALLBACK = Method.getMethod("java.io.InputStream getInputStream(java.net.URLConnection)");
    private static final Method GET_ERROR_STREAM_CALLBACK = Method.getMethod("java.io.InputStream getErrorStream(java.net.HttpURLConnection)");
    private final ClassUtil classUtil;

    public URLConnectionTracking(ClassUtil classUtil) {
        this.classUtil = classUtil;
    }

    @Override
    public ClassVisitor createClassVisitor(ClassVisitor delegate) {
        for (String targetClass : URL_CONNECTION_CLASSES) {
            delegate = new WrapMethodCallInjector(delegate, FEATURE, new MethodCallMatcher(targetClass, METHODS_THAT_CONNECT_AND_READ_BYTES, false, this.classUtil), REQUEST_ABOUT_TO_BE_SENT, REQUEST_HARVESTABLE, NETWORK_ERROR, IO_EXCEPTION, true);
            delegate = new WrapMethodCallInjector(delegate, FEATURE, new MethodCallMatcher(targetClass, METHODS_THAT_WOULD_TRIGGER_REQUEST, false, this.classUtil), REQUEST_ABOUT_TO_BE_SENT, REQUEST_SENT, NETWORK_ERROR, IO_EXCEPTION, true);
            delegate = new ReplaceMethodCallInjector(delegate, new MethodCallMatcher(targetClass, GET_INPUT_STREAM, false, this.classUtil), GET_INPUT_STREAM_CALLBACK, FEATURE);
            delegate = new ReplaceMethodCallInjector(delegate, new MethodCallMatcher(targetClass, GET_ERROR_STREAM, false, this.classUtil), GET_ERROR_STREAM_CALLBACK, FEATURE);
        }
        return delegate;
    }
}

