/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.eumagent.runtime;

import android.app.Activity;
import android.app.Fragment;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import com.appdynamics.eumagent.runtime.Instrumentation;
import com.appdynamics.eumagent.runtime.JSAgentCallback;
import com.appdynamics.eumagent.runtime.logging.ADLog;
import com.appdynamics.eumagent.runtime.private.am;
import com.appdynamics.eumagent.runtime.private.ar;
import com.appdynamics.eumagent.runtime.private.as;
import com.appdynamics.eumagent.runtime.private.bb;
import com.appdynamics.eumagent.runtime.private.be;
import com.appdynamics.eumagent.runtime.private.bx;
import com.appdynamics.eumagent.runtime.private.by;
import com.appdynamics.eumagent.runtime.private.ca;
import com.appdynamics.eumagent.runtime.private.cb;
import com.appdynamics.eumagent.runtime.private.cd;
import com.appdynamics.eumagent.runtime.private.ch;
import com.appdynamics.eumagent.runtime.private.co;
import com.appdynamics.eumagent.runtime.private.cs;
import com.appdynamics.eumagent.runtime.private.ct;
import com.appdynamics.eumagent.runtime.private.q;
import com.appdynamics.eumagent.runtime.private.w;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.ArrayList;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

public class InstrumentationCallbacks {
    public static WeakReference<Activity> currentActivity;

    public static void webViewCrashed(Object object, Throwable throwable) {
        try {
            object = Instrumentation.b;
            if (object != null) {
                ((w)object).a(Thread.currentThread(), throwable);
                return;
            }
            ADLog.logInfo("Crash Reporting has been disabled, not reporting crash");
            return;
        }
        catch (Throwable throwable2) {
            ADLog.logAgentError("Exception while reporting crash", throwable2);
            return;
        }
    }

    public static void onCreateCalled(Activity activity, Bundle bundle) {
        InstrumentationCallbacks.reportActivityLifecycleEvent(activity, 0);
    }

    public static void onStartCalled(Activity activity) {
        InstrumentationCallbacks.reportActivityLifecycleEvent(activity, 1);
    }

    public static void onResumeCalled(Activity activity) {
        InstrumentationCallbacks.reportActivityLifecycleEvent(activity, 2);
        currentActivity = new WeakReference<Activity>(activity);
        if (!Instrumentation.initializationStarted) {
            return;
        }
        try {
            Object object = Instrumentation.d;
            if (activity.getWindow() != null && object != null) {
                ((ch)object).a(activity.getWindow().getDecorView());
            }
            if ((object = Instrumentation.a) != null) {
                activity = activity.getWindow().getDecorView().getRootView();
                ((am)object).a(new be((View)activity));
            }
            return;
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while trying to watch root view", throwable);
            return;
        }
    }

    public static void onPauseCalled(Activity activity) {
        InstrumentationCallbacks.reportActivityLifecycleEvent(activity, 3);
    }

    public static void onStopCalled(Activity activity) {
        InstrumentationCallbacks.reportActivityLifecycleEvent(activity, 4);
    }

    public static void onDestroyCalled(Activity activity) {
        InstrumentationCallbacks.reportActivityLifecycleEvent(activity, 6);
    }

    public static void onRestartCalled(Activity activity) {
        InstrumentationCallbacks.reportActivityLifecycleEvent(activity, 5);
    }

    public static void onConfigurationChangedCalled(Activity activity, Configuration configuration) {
        if (!Instrumentation.initializationStarted) {
            return;
        }
        try {
            if (Instrumentation.h != null) {
                activity = activity.getWindow().getDecorView().getRootView();
                Instrumentation.a.a(new be((View)activity));
            }
            return;
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while dispatching orientation changed event", throwable);
            return;
        }
    }

    public static void dispatchTouchEventCalled(Activity object, MotionEvent motionEvent) {
        if (!Instrumentation.initializationStarted) {
            return;
        }
        try {
            object = Instrumentation.h;
            if (object != null) {
                object = object.l;
                q q2 = object;
                if (!(object.b.screenshotsEnabled && q2.a.a != false && !Instrumentation.screenshotsBlocked() && object.a.c != false)) {
                    return;
                }
                Instrumentation.a.a(MotionEvent.obtain((MotionEvent)motionEvent));
            }
            return;
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while capturing touch", throwable);
            return;
        }
    }

    private static void reportActivityLifecycleEvent(Activity object, int n2) {
        try {
            object = object != null ? object.getClass().getName() : "null";
            object = new by((String)object, n2);
            Instrumentation.a.a(object);
            return;
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while reporting Activity lifecycle event", throwable);
            return;
        }
    }

    public static void onStartCalled(Fragment fragment) {
        InstrumentationCallbacks.reportFragmentLifecycleEvent(fragment, 0);
    }

    public static void onStopCalled(Fragment fragment) {
        InstrumentationCallbacks.reportFragmentLifecycleEvent(fragment, 1);
    }

    private static void reportFragmentLifecycleEvent(Fragment fragment, int n2) {
        try {
            String string2 = fragment != null ? fragment.getClass().getName() : "Unknown";
            int n3 = fragment != null ? System.identityHashCode(fragment) : -1;
            cd cd2 = new cd(string2, n3, n2, new cs());
            Instrumentation.a.a(cd2);
            return;
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while reporting Fragment lifecycle event", throwable);
            return;
        }
    }

    public static void onPauseCalled(androidx.fragment.app.Fragment fragment) {
        InstrumentationCallbacks.reportFragmentLifecycleEvent(fragment, 2);
    }

    public static void onResumeCalled(androidx.fragment.app.Fragment fragment) {
        InstrumentationCallbacks.reportFragmentLifecycleEvent(fragment, 3);
    }

    public static void onStartCalled(androidx.fragment.app.Fragment fragment) {
        InstrumentationCallbacks.reportFragmentLifecycleEvent(fragment, 0);
    }

    public static void onStopCalled(androidx.fragment.app.Fragment fragment) {
        InstrumentationCallbacks.reportFragmentLifecycleEvent(fragment, 1);
    }

    private static void reportFragmentLifecycleEvent(androidx.fragment.app.Fragment fragment, int n2) {
        try {
            String string2 = fragment != null ? fragment.getClass().getName() : "Unknown";
            int n3 = fragment != null ? System.identityHashCode(fragment) : -1;
            cd cd2 = new cd(string2, n3, n2, new cs());
            Instrumentation.a.a(cd2);
            return;
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while reporting Fragment lifecycle event", throwable);
            return;
        }
    }

    public static void requestAboutToBeSent(URLConnection uRLConnection) {
        try {
            ADLog.logVerbose("InstrumentationCallbacks.requestAboutToBeSent called");
            Instrumentation instrumentation = Instrumentation.h;
            if (instrumentation != null && instrumentation.i != null && uRLConnection instanceof HttpURLConnection) {
                instrumentation.i.b((HttpURLConnection)uRLConnection);
            }
            return;
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception in pre-request handler", throwable);
            return;
        }
    }

    public static void requestSent(URLConnection uRLConnection) {
        try {
            ADLog.logVerbose("InstrumentationCallbacks.requestSent called");
            Instrumentation instrumentation = Instrumentation.h;
            if (instrumentation != null && instrumentation.i != null && uRLConnection instanceof HttpURLConnection) {
                instrumentation.i.c((HttpURLConnection)uRLConnection);
            }
            return;
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception in post-request handler", throwable);
            return;
        }
    }

    public static void requestHarvestable(URLConnection uRLConnection) {
        try {
            ADLog.logVerbose("InstrumentationCallbacks.requestHarvestable called");
            Instrumentation instrumentation = Instrumentation.h;
            if (instrumentation != null && instrumentation.i != null && uRLConnection instanceof HttpURLConnection) {
                instrumentation.i.c((HttpURLConnection)uRLConnection);
                instrumentation.i.a((HttpURLConnection)uRLConnection);
            }
            return;
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception in marking request as reportable", throwable);
            return;
        }
    }

    public static void networkError(URLConnection uRLConnection, IOException iOException) {
        try {
            ADLog.logVerbose("InstrumentationCallbacks.networkError called");
            Instrumentation instrumentation = Instrumentation.h;
            if (instrumentation != null && instrumentation.i != null && uRLConnection instanceof HttpURLConnection) {
                instrumentation.i.a((HttpURLConnection)uRLConnection, iOException);
            }
            return;
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception in network request handler", throwable);
            return;
        }
    }

    public static InputStream getInputStream(URLConnection uRLConnection) {
        Object object;
        try {
            ADLog.logVerbose("InstrumentationCallbacks.getInputStream called");
            object = Instrumentation.h;
            if (object != null && ((Instrumentation)object).i != null && uRLConnection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                object = ((Instrumentation)object).i;
                return new bb.a((bb)object, httpURLConnection){
                    private /* synthetic */ HttpURLConnection b;
                    {
                        this.b = httpURLConnection;
                        super(bb2, (byte)0);
                    }

                    final InputStream a() {
                        return this.b.getInputStream();
                    }
                }.a(httpURLConnection);
            }
        }
        catch (co co2) {
            object = co2;
            InstrumentationCallbacks.strip(co2.getCause());
            ((co)object).a(IOException.class);
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while fetching input stream", throwable);
        }
        try {
            return uRLConnection.getInputStream();
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
        catch (IOException iOException) {
            object = iOException;
            InstrumentationCallbacks.strip(iOException);
            throw object;
        }
    }

    public static InputStream getErrorStream(HttpURLConnection httpURLConnection) {
        Object object;
        try {
            ADLog.logVerbose("InstrumentationCallbacks.getErrorStream called");
            object = Instrumentation.h;
            if (object != null && ((Instrumentation)object).i != null) {
                HttpURLConnection httpURLConnection2 = httpURLConnection;
                object = ((Instrumentation)object).i;
                return new bb.a((bb)object, httpURLConnection2){
                    private /* synthetic */ HttpURLConnection b;
                    {
                        this.b = httpURLConnection;
                        super(bb2, (byte)0);
                    }

                    final InputStream a() {
                        return this.b.getErrorStream();
                    }
                }.a(httpURLConnection2);
            }
        }
        catch (co co2) {
            object = co2;
            InstrumentationCallbacks.strip(co2.getCause());
            ((co)object).a();
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while fetching error stream", throwable);
        }
        try {
            return httpURLConnection.getErrorStream();
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
    }

    public static HttpResponse execute(HttpClient httpClient, HttpUriRequest httpUriRequest) {
        Object object;
        try {
            ADLog.logVerbose("InstrumentationCallbacks.execute(HttpClient, HttpUriRequest) called");
            object = Instrumentation.h;
            if (object != null && ((Instrumentation)object).j != null) {
                return ((Instrumentation)object).j.a(httpClient, httpUriRequest);
            }
        }
        catch (co co2) {
            object = co2;
            InstrumentationCallbacks.strip(co2.getCause());
            ((co)object).a(IOException.class);
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while executing http request", throwable);
        }
        try {
            return httpClient.execute(httpUriRequest);
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
        catch (IOException iOException) {
            object = iOException;
            InstrumentationCallbacks.strip(iOException);
            throw object;
        }
    }

    public static HttpResponse execute(HttpClient httpClient, HttpUriRequest httpUriRequest, HttpContext httpContext) {
        Object object;
        try {
            ADLog.logVerbose("InstrumentationCallbacks.execute(HttpClient, HttpUriRequest, HttpContext) called");
            object = Instrumentation.h;
            if (object != null && ((Instrumentation)object).j != null) {
                return ((Instrumentation)object).j.a(httpClient, httpUriRequest, httpContext);
            }
        }
        catch (co co2) {
            object = co2;
            InstrumentationCallbacks.strip(co2.getCause());
            ((co)object).a(IOException.class);
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while executing http request", throwable);
        }
        try {
            return httpClient.execute(httpUriRequest, httpContext);
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
        catch (IOException iOException) {
            object = iOException;
            InstrumentationCallbacks.strip(iOException);
            throw object;
        }
    }

    public static HttpResponse execute(HttpClient httpClient, HttpHost httpHost, HttpRequest httpRequest) {
        Object object;
        try {
            ADLog.logVerbose("InstrumentationCallbacks.execute(HttpClient, HttpHost, HttpRequest) called");
            object = Instrumentation.h;
            if (object != null && ((Instrumentation)object).j != null) {
                return ((Instrumentation)object).j.a(httpClient, httpHost, httpRequest);
            }
        }
        catch (co co2) {
            object = co2;
            InstrumentationCallbacks.strip(co2.getCause());
            ((co)object).a(IOException.class);
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while executing http request", throwable);
        }
        try {
            return httpClient.execute(httpHost, httpRequest);
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
        catch (IOException iOException) {
            object = iOException;
            InstrumentationCallbacks.strip(iOException);
            throw object;
        }
    }

    public static HttpResponse execute(HttpClient httpClient, HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) {
        Object object;
        try {
            ADLog.logVerbose("InstrumentationCallbacks.execute(HttpClient, HttpHost, HttpRequest, HttpContext) called");
            object = Instrumentation.h;
            if (object != null && ((Instrumentation)object).j != null) {
                return ((Instrumentation)object).j.a(httpClient, httpHost, httpRequest, httpContext);
            }
        }
        catch (co co2) {
            object = co2;
            InstrumentationCallbacks.strip(co2.getCause());
            ((co)object).a(IOException.class);
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while executing http request", throwable);
        }
        try {
            return httpClient.execute(httpHost, httpRequest, httpContext);
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
        catch (IOException iOException) {
            object = iOException;
            InstrumentationCallbacks.strip(iOException);
            throw object;
        }
    }

    public static Object execute(HttpClient httpClient, HttpUriRequest httpUriRequest, ResponseHandler responseHandler) {
        Object object;
        try {
            ADLog.logVerbose("InstrumentationCallbacks.execute(HttpClient, HttpUriRequest, ResponseHandler) called");
            object = Instrumentation.h;
            if (object != null && ((Instrumentation)object).j != null) {
                return ((Instrumentation)object).j.a(httpClient, httpUriRequest, responseHandler);
            }
        }
        catch (co co2) {
            object = co2;
            InstrumentationCallbacks.strip(co2.getCause());
            ((co)object).a(IOException.class);
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while executing http request", throwable);
        }
        try {
            return httpClient.execute(httpUriRequest, responseHandler);
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
        catch (IOException iOException) {
            object = iOException;
            InstrumentationCallbacks.strip(iOException);
            throw object;
        }
    }

    public static Object execute(HttpClient httpClient, HttpUriRequest httpUriRequest, ResponseHandler responseHandler, HttpContext httpContext) {
        Object object;
        try {
            ADLog.logVerbose("InstrumentationCallbacks.execute(HttpClient, HttpUriRequest, ResponseHandler, HttpContext) called");
            object = Instrumentation.h;
            if (object != null && ((Instrumentation)object).j != null) {
                return ((Instrumentation)object).j.a(httpClient, httpUriRequest, responseHandler, httpContext);
            }
        }
        catch (co co2) {
            object = co2;
            InstrumentationCallbacks.strip(co2.getCause());
            ((co)object).a(IOException.class);
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while executing http request", throwable);
        }
        try {
            return httpClient.execute(httpUriRequest, responseHandler, httpContext);
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
        catch (IOException iOException) {
            object = iOException;
            InstrumentationCallbacks.strip(iOException);
            throw object;
        }
    }

    public static Object execute(HttpClient httpClient, HttpHost httpHost, HttpRequest httpRequest, ResponseHandler responseHandler) {
        Object object;
        try {
            ADLog.logVerbose("InstrumentationCallbacks.execute(HttpClient, HttpHost, HttpRequest, ResponseHandler) called");
            object = Instrumentation.h;
            if (object != null && ((Instrumentation)object).j != null) {
                return ((Instrumentation)object).j.a(httpClient, httpHost, httpRequest, responseHandler);
            }
        }
        catch (co co2) {
            object = co2;
            InstrumentationCallbacks.strip(co2.getCause());
            ((co)object).a(IOException.class);
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while executing http request", throwable);
        }
        try {
            return httpClient.execute(httpHost, httpRequest, responseHandler);
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
        catch (IOException iOException) {
            object = iOException;
            InstrumentationCallbacks.strip(iOException);
            throw object;
        }
    }

    public static Object execute(HttpClient httpClient, HttpHost httpHost, HttpRequest httpRequest, ResponseHandler responseHandler, HttpContext httpContext) {
        Object object;
        try {
            ADLog.logVerbose("InstrumentationCallbacks.execute(HttpClient, HttpHost, HttpRequest, ResponseHandler, HttpContext) called");
            object = Instrumentation.h;
            if (object != null && ((Instrumentation)object).j != null) {
                return ((Instrumentation)object).j.a(httpClient, httpHost, httpRequest, responseHandler, httpContext);
            }
        }
        catch (co co2) {
            object = co2;
            InstrumentationCallbacks.strip(co2.getCause());
            ((co)object).a(IOException.class);
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while executing http request", throwable);
        }
        try {
            return httpClient.execute(httpHost, httpRequest, responseHandler, httpContext);
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
        catch (IOException iOException) {
            object = iOException;
            InstrumentationCallbacks.strip(iOException);
            throw object;
        }
    }

    public static void setOnHierarchyChangeListenerCalled(ViewGroup viewGroup, ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
        Object object;
        try {
            ADLog.logVerbose("InstrumentationCallbacks.OnSetOnHierarchyChangeListener(ViewGroup, OnHierarchyChangeListener) called");
            object = Instrumentation.d;
            if (Instrumentation.initializationStarted && object != null) {
                ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener2 = onHierarchyChangeListener;
                ViewGroup viewGroup2 = viewGroup;
                if (!((ch)object).c.get().booleanValue()) {
                    ((ch)object).c.set(Boolean.TRUE);
                    if (onHierarchyChangeListener2 == ((ch)object).b) {
                        ((ch)object).c.set(Boolean.FALSE);
                        return;
                    }
                    if (onHierarchyChangeListener2 != null) {
                        ((ch)object).a.put((View)viewGroup2, onHierarchyChangeListener2);
                    } else {
                        ((ch)object).a.remove(viewGroup2);
                    }
                    viewGroup2.setOnHierarchyChangeListener(((ch)object).b);
                    ((ch)object).c.set(Boolean.FALSE);
                    return;
                }
                ADLog.logWarning("setOnHierarchyChangeListener detected recursion.");
                return;
            }
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while setting hierarchy change listener on view group", throwable);
        }
        try {
            viewGroup.setOnHierarchyChangeListener(onHierarchyChangeListener);
            return;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
    }

    public static void setOnClickListenerCalled(View view, View.OnClickListener onClickListener) {
        Object object;
        try {
            ADLog.logVerbose("InstrumentationCallbacks.setOnClickListenerCalled(View, OnClickListener) called");
            object = Instrumentation.e;
            if (Instrumentation.initializationStarted && view instanceof Button && object != null) {
                ((ca)object).a(view, onClickListener);
                return;
            }
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while setting click listener on view", throwable);
        }
        try {
            view.setOnClickListener(onClickListener);
            return;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
    }

    public static void setOnItemClickListenerCalled(AdapterView adapterView, AdapterView.OnItemClickListener onItemClickListener) {
        Object object;
        try {
            ADLog.logVerbose("InstrumentationCallbacks.setOnItemClickListenerCalled(AdapterView, OnItemClickListener) called");
            object = Instrumentation.f;
            if (Instrumentation.initializationStarted && object != null) {
                ((bx)object).a(adapterView, onItemClickListener);
                return;
            }
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while setting click listener on view", throwable);
        }
        try {
            adapterView.setOnItemClickListener(onItemClickListener);
            return;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
    }

    public static void setOnFocusChangeListenerCalled(View view, View.OnFocusChangeListener onFocusChangeListener) {
        Object object;
        try {
            ADLog.logVerbose("InstrumentationCallbacks.setOnFocusChangeListenerCalled(View, OnFocusChangeListener) called");
            object = Instrumentation.g;
            if (Instrumentation.initializationStarted && view instanceof EditText && object != null) {
                ((cb)object).a(view, onFocusChangeListener);
                return;
            }
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while setting focus change listener on view", throwable);
        }
        try {
            view.setOnFocusChangeListener(onFocusChangeListener);
            return;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
    }

    private static void strip(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        try {
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
            boolean bl2 = false;
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (stackTraceElement.getClassName() != null && stackTraceElement.getClassName().startsWith("com.appdynamics.eumagent.runtime")) {
                    bl2 = true;
                    continue;
                }
                arrayList.add(stackTraceElement);
            }
            if (bl2) {
                ArrayList<StackTraceElement> arrayList2 = arrayList;
                throwable.setStackTrace(arrayList2.toArray(new StackTraceElement[arrayList2.size()]));
            }
            return;
        }
        catch (Throwable throwable2) {
            ADLog.logAgentError("Failed to strip stacktrace", throwable2);
            return;
        }
    }

    public static void reportAgentError(String object, Throwable object2) {
        Object object3 = Instrumentation.h;
        if (object3 != null) {
            object3 = object2;
            object2 = object;
            object = ((Instrumentation)object3).k;
            long l2 = SystemClock.uptimeMillis();
            if (l2 > ((as)object).b + 60000L) {
                object2 = new ar((String)object2, (Throwable)object3, ((as)object).c);
                ((as)object).d.a(object2);
                ((as)object).c = 0;
                ((as)object).b = l2;
                return;
            }
            ++((as)object).c;
        }
    }

    public static void loadUrlCalled(WebView webView) {
        try {
            block5: {
                block4: {
                    ADLog.logVerbose("loadUrl(String url) called");
                    Object object = Instrumentation.h;
                    if (webView == null || object == null) break block4;
                    object = ((Instrumentation)object).l;
                    if (((q)object).b.jsAgentInjectionEnabled && ((q)object).a.e != false) break block5;
                }
                return;
            }
            ADLog.logVerbose("adding JS callback handler to WebView");
            webView.addJavascriptInterface((Object)new JSAgentCallback(), "ADEUM_js_handler");
            return;
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while setting JS callback on WebView", throwable);
            return;
        }
    }

    public static void postUrlCalled(WebView webView) {
        try {
            block5: {
                block4: {
                    ADLog.logVerbose("postUrl(String url) called");
                    Object object = Instrumentation.h;
                    if (webView == null || object == null) break block4;
                    object = ((Instrumentation)object).l;
                    if (((q)object).b.jsAgentInjectionEnabled && ((q)object).a.e != false) break block5;
                }
                return;
            }
            ADLog.logVerbose("adding JS callback handler to WebView");
            webView.addJavascriptInterface((Object)new JSAgentCallback(), "ADEUM_js_handler");
            return;
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while setting JS callback on WebView", throwable);
            return;
        }
    }

    public static void onPageFinishedCalled(WebViewClient object, WebView webView, String object2) {
        try {
            ADLog.logVerbose("onPageFinishedCalled");
            if (webView == null) {
                return;
            }
            if (webView.getClass().getName().contains("cordova")) {
                ADLog.logVerbose("injecting JS Agent into Cordova WebView");
                webView.loadUrl(ct.a(true));
                return;
            }
            object = Instrumentation.h;
            if (object != null) {
                object2 = object.l;
                if (!(((q)object2).b.jsAgentInjectionEnabled && ((q)object2).a.e != false)) {
                    return;
                }
                ADLog.logVerbose("injecting JS Agent");
                object = object.l;
                object2 = object;
                webView.loadUrl(ct.a(object.b.jsAgentInjectionEnabled && ((q)object2).a.e != false && object.a.g != false));
            }
            return;
        }
        catch (Throwable throwable) {
            ADLog.logAgentError("Exception while injecting JS into WebView", throwable);
            return;
        }
    }
}

