/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.eumagent.runtime.devicemetrics;

import android.app.ActivityManager;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Environment;
import android.os.PowerManager;
import android.os.StatFs;
import com.appdynamics.eumagent.runtime.logging.ADLog;
import com.appdynamics.eumagent.runtime.private.ak;
import com.appdynamics.eumagent.runtime.private.am;
import com.appdynamics.eumagent.runtime.private.q;
import java.util.Timer;
import java.util.TimerTask;

public class DeviceMetricsCollector {
    private Context applicationContext;
    private q configurationManager;
    private am eventBus;
    private Integer currentCollectionFrequencyInMinutes;
    private Boolean currentChargingState;
    private Boolean currentPowerState;

    public DeviceMetricsCollector(q q2, Context context, am am2) {
        this.applicationContext = context;
        this.configurationManager = q2;
        this.eventBus = am2;
        this.currentCollectionFrequencyInMinutes = q2.a.m != null ? q2.a.m : 2;
        this.currentChargingState = null;
        this.currentPowerState = null;
        DeviceMetricsCollector deviceMetricsCollector = this;
        deviceMetricsCollector.scheduleAndRunCollection(deviceMetricsCollector.currentCollectionFrequencyInMinutes);
        ADLog.logInfo("Device Metrics system initialized");
    }

    public DeviceMetricsCollector(q q2, Context context) {
        this.applicationContext = context;
        this.configurationManager = q2;
        this.currentCollectionFrequencyInMinutes = q2.a.m != null ? q2.a.m : 2;
        this.currentChargingState = null;
        this.currentPowerState = null;
    }

    private void scheduleAndRunCollection(Integer n2) {
        new Timer().scheduleAtFixedRate((TimerTask)new a(this, 0), 0L, (long)(n2 * 60000));
    }

    public DeviceMetricsCollector(Context context) {
        this.applicationContext = context;
    }

    public Long getTotalMemoryInMegaBytes() {
        try {
            ActivityManager activityManager = (ActivityManager)this.applicationContext.getSystemService("activity");
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            activityManager.getMemoryInfo(memoryInfo);
            return DeviceMetricsCollector.byteToMBytes(memoryInfo.totalMem);
        }
        catch (Exception exception) {
            ADLog.logAgentError("Unable to retrieve total memory info", exception);
            return null;
        }
    }

    public Long getAvailableMemoryInMegaBytes() {
        try {
            ActivityManager activityManager = (ActivityManager)this.applicationContext.getSystemService("activity");
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            activityManager.getMemoryInfo(memoryInfo);
            return DeviceMetricsCollector.byteToMBytes(memoryInfo.availMem);
        }
        catch (Exception exception) {
            ADLog.logAgentError("Unable to retrieve available memory info", exception);
            return null;
        }
    }

    public Long getTotalDiskSpaceInMegaBytes() {
        try {
            String string2 = Environment.getDataDirectory().toString();
            return DeviceMetricsCollector.byteToMBytes(new StatFs(string2).getTotalBytes());
        }
        catch (RuntimeException runtimeException) {
            ADLog.logAgentError("Unable to retrieve total disk space info", runtimeException);
            return null;
        }
    }

    public Long getAvailableDiskSpaceInMegaBytes() {
        try {
            String string2 = Environment.getDataDirectory().toString();
            return DeviceMetricsCollector.byteToMBytes(new StatFs(string2).getAvailableBytes());
        }
        catch (RuntimeException runtimeException) {
            ADLog.logAgentError("Unable to retrieve available disk space info", runtimeException);
            return null;
        }
    }

    public Double getTotalBatteryCapacity() {
        Object var1_1 = null;
        try {
            var1_1 = Class.forName("com.android.internal.os.PowerProfile").getConstructor(Context.class).newInstance(this.applicationContext);
        }
        catch (Exception exception) {
            ADLog.logAgentError("Unable to set power profile", exception);
        }
        try {
            return (Double)Class.forName("com.android.internal.os.PowerProfile").getMethod("getAveragePower", String.class).invoke(var1_1, "battery.capacity");
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            ADLog.logAgentError("Unable to retrieve battery capacity", exception2);
            return 0.0;
        }
    }

    public Integer getBatteryLevel() {
        try {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            intentFilter = this.applicationContext.registerReceiver(null, intentFilter);
            if (intentFilter == null) {
                ADLog.logAgentError("Unable to retrieve battery level");
                return 0;
            }
            return intentFilter.getIntExtra("level", -1);
        }
        catch (Exception exception) {
            ADLog.logAgentError("Unable to retrieve battery level", exception);
            return null;
        }
    }

    public Boolean getChargingState() {
        try {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            intentFilter = this.applicationContext.registerReceiver(null, intentFilter);
            if (intentFilter == null) {
                ADLog.logAgentError("Unable to retrieve charging state");
                return Boolean.FALSE;
            }
            return intentFilter.getIntExtra("status", -1) == 2;
        }
        catch (Exception exception) {
            ADLog.logAgentError("Unable to retrieve charging state", exception);
            return null;
        }
    }

    public Boolean getPowerMode() {
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                return ((PowerManager)this.applicationContext.getSystemService("power")).isPowerSaveMode();
            }
            ADLog.logAgentError("Unable to retrieve battery power mode");
        }
        catch (Exception exception) {
            ADLog.logAgentError("Unable to retrieve battery power mode");
        }
        return Boolean.FALSE;
    }

    public Boolean shouldCollectStorageDeviceSpecification() {
        q q2 = this.configurationManager;
        return q2.a.k != null ? q2.a.k : false;
    }

    public Boolean shouldCollectBatteryDeviceSpecification() {
        q q2 = this.configurationManager;
        return q2.a.l != null ? q2.a.l : false;
    }

    public Boolean shouldCollectMemoryDeviceSpecification() {
        q q2 = this.configurationManager;
        return q2.a.j != null ? q2.a.j : false;
    }

    public static long byteToMBytes(long l2) {
        return l2 / 0x100000L;
    }

    private ak populateDeviceMetricsEvent() {
        ak.a a2 = new ak.a();
        Object object = this.getAvailableDiskSpaceInMegaBytes();
        Long l2 = this.getAvailableMemoryInMegaBytes();
        Integer n2 = this.getBatteryLevel();
        Boolean bl2 = this.getChargingState();
        Boolean bl3 = this.getPowerMode();
        Object object2 = this.configurationManager;
        if (((q)object2).a.k != null ? ((q)object2).a.k : false) {
            object2 = this.getTotalDiskSpaceInMegaBytes();
            if (object != null && object2 != null) {
                object = 100.0 * (((Long)object).doubleValue() / ((Long)object2).doubleValue());
                object2 = this.configurationManager;
                object2 = ((q)object2).a.p != null ? ((q)object2).a.p : 90;
                if ((Integer)(object = Integer.valueOf(100 - ((Double)object).intValue())) >= (Integer)object2 && (Integer)object >= 0 && (Integer)object <= 100) {
                    a2.b = object;
                }
            }
        }
        object2 = this.configurationManager;
        if (((q)object2).a.j != null ? ((q)object2).a.j : false) {
            object2 = this.getTotalMemoryInMegaBytes();
            if (l2 != null && object2 != null) {
                object = 100.0 * (this.getAvailableMemoryInMegaBytes().doubleValue() / this.getTotalMemoryInMegaBytes().doubleValue());
                object2 = this.configurationManager;
                object2 = ((q)object2).a.n != null ? ((q)object2).a.n : 90;
                if ((Integer)(object = Integer.valueOf(100 - ((Double)object).intValue())) >= (Integer)object2 && (Integer)object >= 0 && (Integer)object <= 100) {
                    a2.a = object;
                }
            }
        }
        object2 = this.configurationManager;
        if (((q)object2).a.l != null ? ((q)object2).a.l : false) {
            if (n2 != null) {
                object2 = this.configurationManager;
                if (n2 <= 100 - (((q)object2).a.o != null ? ((q)object2).a.o : 90)) {
                    object = 100 - n2;
                    a2.c = object;
                }
            }
            if (bl2 != this.currentChargingState || bl2.booleanValue()) {
                this.currentChargingState = bl2;
                object = bl2;
                a2.d = object;
            }
            if (bl3 != this.currentPowerState || bl3.booleanValue()) {
                this.currentPowerState = bl3;
                object = bl3;
                a2.e = object;
            }
        }
        object = this.applicationContext;
        object2 = a2;
        a2.f = object;
        object = new ak();
        ak.a((ak)object, ((ak.a)object2).a);
        ak.b((ak)object, ((ak.a)object2).b);
        ak.c((ak)object, ((ak.a)object2).c);
        ak.a((ak)object, ((ak.a)object2).d);
        ak.b((ak)object, ((ak.a)object2).e);
        ak.a((ak)object, ((ak.a)object2).f);
        return object;
    }

    final class a
    extends TimerTask {
        private /* synthetic */ DeviceMetricsCollector a;

        private a(DeviceMetricsCollector deviceMetricsCollector) {
            this.a = deviceMetricsCollector;
        }

        @Override
        public final void run() {
            Object object = this.a.populateDeviceMetricsEvent();
            this.a.eventBus.a(object);
            object = this.a.configurationManager;
            if ((((q)object).a.m != null ? ((q)object).a.m : 2) != this.a.currentCollectionFrequencyInMinutes) {
                if (!this.cancel()) {
                    ADLog.logAgentError("Failed to reschedule device metrics resource consumption task");
                    return;
                }
                object = this.a.configurationManager;
                this.a.currentCollectionFrequencyInMinutes = ((q)object).a.m != null ? ((q)object).a.m : 2;
                this.a.scheduleAndRunCollection(this.a.currentCollectionFrequencyInMinutes);
                ADLog.logInfo("Device Metrics collection frequency updated to: " + this.a.currentCollectionFrequencyInMinutes);
            }
        }

        /* synthetic */ a(DeviceMetricsCollector deviceMetricsCollector, byte by2) {
            this(deviceMetricsCollector);
        }
    }
}

