/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.eumagent.runtime.logging;

import android.util.Log;
import com.appdynamics.eumagent.runtime.DontObfuscate;
import com.appdynamics.eumagent.runtime.InstrumentationCallbacks;

@DontObfuscate
public class ADLog {
    public static final String TAG = "AppDynamics";
    public static final int VERBOSE = 1;
    public static final int INFO = 2;
    public static final int ERROR = 3;
    public static final int NONE = 4;
    private static int agentLoggingLevel = 4;

    public static void setLoggingLevel(int n2) {
        agentLoggingLevel = n2;
    }

    public static void logInfo(String string2) {
        if (ADLog.isInfoLoggingEnabled()) {
            Log.i((String)TAG, (String)string2);
        }
    }

    public static void logVerbose(String string2) {
        if (ADLog.isVerboseLoggingEnabled()) {
            Log.i((String)TAG, (String)string2);
        }
    }

    public static void log(int n2, String string2, int n3) {
        if (ADLog.isLogLevelEnabled(n2)) {
            Log.i((String)TAG, (String)String.format(string2, n3));
        }
    }

    public static void log(int n2, String string2, Object object) {
        if (ADLog.isLogLevelEnabled(n2)) {
            Log.i((String)TAG, (String)String.format(string2, object));
        }
    }

    public static void log(int n2, String string2, Object object, Object object2) {
        if (ADLog.isLogLevelEnabled(n2)) {
            Log.i((String)TAG, (String)String.format(string2, object, object2));
        }
    }

    public static void log(int n2, String string2, Object object, Object object2, Object object3) {
        if (ADLog.isLogLevelEnabled(n2)) {
            Log.i((String)TAG, (String)String.format(string2, object, object2, object3));
        }
    }

    public static void logWarning(String string2) {
        if (ADLog.isInfoLoggingEnabled()) {
            Log.w((String)TAG, (String)string2);
        }
    }

    public static void logAppError(String string2) {
        if (ADLog.isInfoLoggingEnabled()) {
            Log.e((String)TAG, (String)string2);
        }
    }

    public static void logAppError(String string2, Throwable throwable) {
        if (ADLog.isInfoLoggingEnabled()) {
            Log.e((String)TAG, (String)string2, (Throwable)throwable);
        }
    }

    public static void logAgentError(String string2) {
        ADLog.logAgentError(string2, null);
    }

    public static void logAgentError(String string2, Throwable throwable) {
        try {
            if (ADLog.isInfoLoggingEnabled()) {
                Log.e((String)TAG, (String)string2, (Throwable)throwable);
            }
            InstrumentationCallbacks.reportAgentError(string2, throwable);
            return;
        }
        catch (Throwable throwable2) {
            if (ADLog.isInfoLoggingEnabled()) {
                Log.e((String)TAG, (String)"Error sending log message", (Throwable)throwable);
            }
            return;
        }
    }

    private static boolean isLogLevelEnabled(int n2) {
        return n2 >= agentLoggingLevel && n2 < 4;
    }

    public static boolean isInfoLoggingEnabled() {
        return ADLog.isLogLevelEnabled(2);
    }

    public static boolean isVerboseLoggingEnabled() {
        return ADLog.isLogLevelEnabled(1);
    }
}

