/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.eumagent.runtime;

import android.content.Context;
import com.appdynamics.eumagent.runtime.CollectorChannel;
import com.appdynamics.eumagent.runtime.CollectorChannelFactory;
import com.appdynamics.eumagent.runtime.CrashReportCallback;
import com.appdynamics.eumagent.runtime.DontObfuscate;
import com.appdynamics.eumagent.runtime.NetworkRequestCallback;
import com.appdynamics.eumagent.runtime.private.m;
import java.util.Set;

@DontObfuscate
public class AgentConfiguration {
    public final String appKey;
    public final String applicationName;
    public final Context context;
    public final String collectorURL;
    public final String screenshotURL;
    public final String blobServiceURL;
    public final int loggingLevel;
    public final CollectorChannelFactory collectorChannelFactory;
    public final Set<String> excludedUrlPatterns;
    public final boolean compileTimeInstrumentationCheck;
    public final boolean autoInstrument;
    public final CrashReportCallback crashCallback;
    public final NetworkRequestCallback networkRequestCallback;
    public final int interactionCaptureMode;
    public final boolean screenshotsEnabled;
    public final boolean sessionReplayEnabled;
    public final boolean jsAgentInjectionEnabled;
    public final boolean jsAgentAjaxEnabled;
    public final boolean crashReportingEnabled;
    public final boolean traceparentHeaderEnabled;

    AgentConfiguration(String string2, Context context, String string3, String string4, String string5, int n2, CollectorChannelFactory collectorChannelFactory, String string6, Set<String> set, boolean bl2, boolean bl3, CrashReportCallback crashReportCallback, NetworkRequestCallback networkRequestCallback, int n3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        this.appKey = string2;
        this.context = context;
        this.collectorURL = string3;
        this.screenshotURL = string4;
        this.blobServiceURL = string5;
        this.loggingLevel = n2;
        this.collectorChannelFactory = collectorChannelFactory;
        this.applicationName = string6;
        this.excludedUrlPatterns = set;
        this.compileTimeInstrumentationCheck = bl2;
        this.autoInstrument = bl3;
        this.crashCallback = crashReportCallback;
        this.networkRequestCallback = networkRequestCallback;
        this.interactionCaptureMode = n3;
        this.screenshotsEnabled = bl4;
        this.sessionReplayEnabled = bl5;
        this.jsAgentInjectionEnabled = bl6;
        this.jsAgentAjaxEnabled = bl7;
        this.crashReportingEnabled = bl8;
        this.traceparentHeaderEnabled = bl9;
    }

    public String toString() {
        return "AgentConfiguration{appKey='" + this.appKey + '\'' + ", context=" + this.context + ", collectorURL='" + this.collectorURL + '\'' + ", loggingLevel=" + this.loggingLevel + ", collectorChannelFactory=" + this.collectorChannelFactory + ", applicationName='" + this.applicationName + '\'' + ", urlFilterPatterns=" + (this.excludedUrlPatterns == null ? null : "[" + this.excludedUrlPatterns.toString() + "]") + ", compileTimeInstrumentationCheck=" + this.compileTimeInstrumentationCheck + ", autoInstrument=" + this.autoInstrument + ", crashCallback=" + this.crashCallback + ", networkRequestCallback=" + this.networkRequestCallback + ", interactionCaptureMode=" + this.interactionCaptureMode + ", screenshotsEnabled=" + this.screenshotsEnabled + ", sessionReplayEnabled=" + this.sessionReplayEnabled + ", jsAgentEnabled=" + this.jsAgentInjectionEnabled + ", jsAgentAjaxEnabled=" + this.jsAgentAjaxEnabled + ", crashReportingEnabled=" + this.crashReportingEnabled + ", traceparentHeaderEnabled=" + this.traceparentHeaderEnabled + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    @DontObfuscate
    public static class Builder {
        private static final String DEFAULT_COLLECTOR_HOST = "https://mobile.eum-appdynamics.com";
        private static final String DEFAULT_SCREENSHOT_HOST = "https://image.eum-appdynamics.com";
        private static final String DEFAULT_BLOB_SERVICE_HOST = "https://blob-service.eum-appdynamics.com";
        private String appKey;
        private String applicationName;
        private Context context;
        private String collectorURL;
        private String screenshotURL;
        private String blobServiceURL;
        private int loggingLevel = 4;
        private int interactionCaptureMode;
        private CollectorChannelFactory collectorChannelFactory;
        private Set<String> excludedUrlPatterns;
        private boolean compileTimeInstrumentationCheck = true;
        private boolean autoInstrument = true;
        private CrashReportCallback crashCallback = null;
        private NetworkRequestCallback networkRequestCallback = null;
        private boolean screenshotsEnabled = true;
        private boolean sessionReplayEnabled = false;
        private boolean jsAgentInjectionEnabled = true;
        private boolean jsAgentAjaxEnabled = false;
        private boolean crashReportingEnabled = true;
        private boolean traceparentHeaderEnabled = false;

        private Builder() {
        }

        public Builder withAppKey(String string2) {
            this.appKey = string2;
            return this;
        }

        public Builder withContext(Context context) {
            this.context = context;
            return this;
        }

        public Builder withCollectorURL(String string2) {
            this.collectorURL = string2;
            return this;
        }

        public Builder withScreenshotURL(String string2) {
            this.screenshotURL = string2;
            return this;
        }

        public Builder withBlobServiceURL(String string2) {
            this.blobServiceURL = string2;
            return this;
        }

        public Builder withApplicationName(String string2) {
            this.applicationName = string2;
            return this;
        }

        public Builder withExcludedUrlPatterns(Set<String> set) {
            this.excludedUrlPatterns = set;
            return this;
        }

        public Builder withLoggingEnabled(boolean bl2) {
            return this.withLoggingLevel(bl2 ? 2 : 4);
        }

        public Builder withLoggingLevel(int n2) {
            switch (n2) {
                case 1: 
                case 2: 
                case 4: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid Logging Level: ".concat(String.valueOf(n2)));
                }
            }
            this.loggingLevel = n2;
            return this;
        }

        public Builder withCompileTimeInstrumentationCheck(boolean bl2) {
            this.compileTimeInstrumentationCheck = bl2;
            return this;
        }

        public Builder withAutoInstrument(boolean bl2) {
            this.autoInstrument = bl2;
            return this;
        }

        public Builder withInteractionCaptureMode(int n2) {
            this.interactionCaptureMode = n2;
            return this;
        }

        public Builder withCollectorChannelFactory(CollectorChannelFactory collectorChannelFactory) {
            this.collectorChannelFactory = collectorChannelFactory;
            return this;
        }

        public Builder withCrashCallback(CrashReportCallback crashReportCallback) {
            this.crashCallback = crashReportCallback;
            return this;
        }

        public Builder withNetworkRequestCallback(NetworkRequestCallback networkRequestCallback) {
            this.networkRequestCallback = networkRequestCallback;
            return this;
        }

        public Builder withScreenshotsEnabled(boolean bl2) {
            this.screenshotsEnabled = bl2;
            return this;
        }

        public Builder withSessionReplayEnabled(boolean bl2) {
            this.sessionReplayEnabled = bl2;
            return this;
        }

        public Builder withJSAgentInjectionEnabled(boolean bl2) {
            this.jsAgentInjectionEnabled = bl2;
            return this;
        }

        public Builder withJSAgentAjaxEnabled(boolean bl2) {
            this.jsAgentAjaxEnabled = bl2;
            return this;
        }

        public Builder withCrashReportingEnabled(boolean bl2) {
            this.crashReportingEnabled = bl2;
            return this;
        }

        public Builder withTraceparentHeaderEnabled(boolean bl2) {
            this.traceparentHeaderEnabled = bl2;
            return this;
        }

        public AgentConfiguration build() {
            if (!this.autoInstrument) {
                this.interactionCaptureMode = 0;
            }
            if (this.screenshotURL == null && this.collectorURL != null) {
                this.screenshotURL = this.collectorURL;
            }
            if (this.screenshotURL == null) {
                this.screenshotURL = DEFAULT_SCREENSHOT_HOST;
            }
            if (this.blobServiceURL == null && this.collectorURL != null) {
                this.blobServiceURL = this.collectorURL;
            }
            if (this.blobServiceURL == null) {
                this.blobServiceURL = DEFAULT_BLOB_SERVICE_HOST;
            }
            if (this.collectorURL == null) {
                this.collectorURL = DEFAULT_COLLECTOR_HOST;
            }
            if (this.collectorChannelFactory == null) {
                this.collectorChannelFactory = new CollectorChannelFactory(){

                    @Override
                    public final CollectorChannel newCollectorChannel() {
                        return new m();
                    }
                };
            }
            return new AgentConfiguration(this.appKey, this.context, this.collectorURL, this.screenshotURL, this.blobServiceURL, this.loggingLevel, this.collectorChannelFactory, this.applicationName, this.excludedUrlPatterns, this.compileTimeInstrumentationCheck, this.autoInstrument, this.crashCallback, this.networkRequestCallback, this.interactionCaptureMode, this.screenshotsEnabled, this.sessionReplayEnabled, this.jsAgentInjectionEnabled, this.jsAgentAjaxEnabled, this.crashReportingEnabled, this.traceparentHeaderEnabled);
        }
    }
}

