/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks.remoterecording;

import com.appland.appmap.config.Properties;
import com.appland.appmap.output.v1.Event;
import com.appland.appmap.process.ExitEarly;
import com.appland.appmap.process.conditions.RecordCondition;
import com.appland.appmap.process.hooks.remoterecording.RemoteRecordingManager;
import com.appland.appmap.process.hooks.remoterecording.ServletRequest;
import com.appland.appmap.record.ActiveSessionException;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.record.Recording;
import com.appland.appmap.reflect.FilterChain;
import com.appland.appmap.reflect.HttpServletRequest;
import com.appland.appmap.reflect.HttpServletResponse;
import com.appland.appmap.transform.annotations.ArgumentArray;
import com.appland.appmap.transform.annotations.CallbackOn;
import com.appland.appmap.transform.annotations.ContinueHooking;
import com.appland.appmap.transform.annotations.ExcludeReceiver;
import com.appland.appmap.transform.annotations.HookAnnotated;
import com.appland.appmap.transform.annotations.HookClass;
import com.appland.appmap.transform.annotations.HookCondition;
import com.appland.appmap.transform.annotations.MethodEvent;
import com.appland.appmap.util.Logger;
import com.appland.appmap.util.StringUtil;
import java.io.File;

public class ServletHooks {
    private static final boolean debug = Properties.DebugHttp;
    private static final Recorder recorder = Recorder.getInstance();

    private static void service(Object[] args) throws ExitEarly {
        if (args.length != 2) {
            return;
        }
        HttpServletRequest req = new HttpServletRequest(args[0]);
        HttpServletResponse res = new HttpServletResponse(args[1]);
        if (RemoteRecordingManager.service(new ServletRequest(req, res))) {
            throw new ExitEarly();
        }
    }

    private static void skipFilterChain(Object[] args) throws ExitEarly {
        if (args.length != 3) {
            if (debug) {
                Logger.println("ToggleRecord.skipFilterChain - invalid arg length");
            }
            return;
        }
        HttpServletRequest req = new HttpServletRequest(args[0]);
        if (!req.getRequestURI().endsWith("/_appmap/record")) {
            return;
        }
        if (debug) {
            Logger.println("ToggleRecord.skipFilterChain - skipping filter chain");
        }
        FilterChain chain = new FilterChain(args[2]);
        chain.doFilter(args[0], args[1]);
        if (debug) {
            Logger.println("ToggleRecord.skipFilterChain - successfully skipped, exiting early");
        }
        throw new ExitEarly();
    }

    @ExcludeReceiver
    @ArgumentArray
    @HookClass(value="javax.servlet.http.HttpServlet")
    public static void service(Event event, Object[] args) throws ExitEarly {
        ServletHooks.service(args);
    }

    @ExcludeReceiver
    @ArgumentArray
    @HookClass(value="jakarta.servlet.http.HttpServlet", method="service")
    public static void serviceJakarta(Event event, Object[] args) throws ExitEarly {
        ServletHooks.service(args);
    }

    @ContinueHooking
    @ExcludeReceiver
    @ArgumentArray
    @HookClass(value="javax.servlet.Filter")
    public static void doFilter(Event event, Object[] args) throws ExitEarly {
        ServletHooks.skipFilterChain(args);
    }

    @ContinueHooking
    @ExcludeReceiver
    @ArgumentArray
    @HookClass(value="jakarta.servlet.Filter", method="doFilter")
    public static void doFilterJakarta(Event event, Object[] args) throws ExitEarly {
        ServletHooks.skipFilterChain(args);
    }

    private static Recorder.Metadata getMetadata(Event event) {
        boolean junit = false;
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        for (int i = 0; !junit && i < stack.length; ++i) {
            if (!stack[i].getClassName().startsWith("org.junit")) continue;
            junit = true;
        }
        Recorder.Metadata metadata = new Recorder.Metadata();
        if (junit) {
            metadata.recorderName = "toggle_record_receiver";
            metadata.framework = "junit";
        } else {
            metadata.recorderName = StringUtil.canonicalName(event.definedClass, event.isStatic, event.methodId);
        }
        return metadata;
    }

    private static void startRecording(Event event) {
        Logger.printf("Recording started for %s\n", StringUtil.canonicalName(event));
        try {
            Recorder.Metadata metadata = ServletHooks.getMetadata(event);
            String feature = StringUtil.identifierToSentence(event.methodId);
            String featureGroup = StringUtil.identifierToSentence(event.definedClass);
            metadata.scenarioName = String.format("%s %s", featureGroup, StringUtil.decapitalize(feature));
            metadata.recordedClassName = event.definedClass;
            metadata.recordedMethodName = event.methodId;
            metadata.sourceLocation = String.join((CharSequence)":", event.path, String.valueOf(event.lineNumber));
            recorder.start(metadata);
        }
        catch (ActiveSessionException e) {
            Logger.printf("%s\n", e.getMessage());
        }
    }

    private static void stopRecording(Event event) {
        ServletHooks.stopRecording(event, null, null);
    }

    private static void stopRecording(Event event, boolean succeeded) {
        ServletHooks.stopRecording(event, succeeded, null);
    }

    private static void stopRecording(Event event, Boolean succeeded, Throwable exception) {
        Logger.printf("Recording stopped for %s\n", StringUtil.canonicalName(event));
        String filePath = String.join((CharSequence)"_", event.definedClass, event.methodId).replaceAll("[^a-zA-Z0-9-_]", "_");
        filePath = filePath + ".appmap.json";
        if (succeeded != null) {
            ServletHooks.recorder.getMetadata().testSucceeded = succeeded;
        }
        if (exception != null) {
            ServletHooks.recorder.getMetadata().exception = exception;
        }
        Recording recording = recorder.stop();
        recording.moveTo(String.join((CharSequence)File.separator, Properties.getOutputDirectory().getPath(), filePath));
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.junit.Test")
    public static void junit(Event event, Object[] args) {
        ServletHooks.startRecording(event);
    }

    @ArgumentArray
    @CallbackOn(value=MethodEvent.METHOD_RETURN)
    @ExcludeReceiver
    @HookAnnotated(value="org.junit.Test")
    public static void junit(Event event, Object returnValue, Object[] args) {
        ServletHooks.stopRecording(event, true);
    }

    @ArgumentArray
    @CallbackOn(value=MethodEvent.METHOD_EXCEPTION)
    @ExcludeReceiver
    @HookAnnotated(value="org.junit.Test")
    public static void junit(Event event, Exception exception, Object[] args) {
        event.setException(exception);
        recorder.add(event);
        ServletHooks.stopRecording(event, false, exception);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.junit.jupiter.api.Test")
    public static void junitJupiter(Event event, Object[] args) {
        ServletHooks.startRecording(event);
    }

    @ArgumentArray
    @CallbackOn(value=MethodEvent.METHOD_RETURN)
    @ExcludeReceiver
    @HookAnnotated(value="org.junit.jupiter.api.Test")
    public static void junitJupiter(Event event, Object returnValue, Object[] args) {
        ServletHooks.stopRecording(event, true);
    }

    @ArgumentArray
    @CallbackOn(value=MethodEvent.METHOD_EXCEPTION)
    @ExcludeReceiver
    @HookAnnotated(value="org.junit.jupiter.api.Test")
    public static void junitJupiter(Event event, Exception exception, Object[] args) {
        event.setException(exception);
        recorder.add(event);
        ServletHooks.stopRecording(event, false, exception);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.testng.annotations.Test")
    public static void testng(Event event, Object[] args) {
        ServletHooks.startRecording(event);
    }

    @ArgumentArray
    @CallbackOn(value=MethodEvent.METHOD_RETURN)
    @ExcludeReceiver
    @HookAnnotated(value="org.testng.annotations.Test")
    public static void testng(Event event, Object returnValue, Object[] args) {
        ServletHooks.stopRecording(event, true);
    }

    @ArgumentArray
    @CallbackOn(value=MethodEvent.METHOD_EXCEPTION)
    @ExcludeReceiver
    @HookAnnotated(value="org.testng.annotations.Test")
    public static void testng(Event event, Exception exception, Object[] args) {
        event.setException(exception);
        recorder.add(event);
        ServletHooks.stopRecording(event, false, exception);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookCondition(value=RecordCondition.class)
    public static void record(Event event, Object[] args) {
        ServletHooks.startRecording(event);
    }

    @ArgumentArray
    @CallbackOn(value=MethodEvent.METHOD_RETURN)
    @ExcludeReceiver
    @HookCondition(value=RecordCondition.class)
    public static void record(Event event, Object returnValue, Object[] args) {
        ServletHooks.stopRecording(event);
    }

    @ArgumentArray
    @CallbackOn(value=MethodEvent.METHOD_EXCEPTION)
    @ExcludeReceiver
    @HookCondition(value=RecordCondition.class)
    public static void record(Event event, Exception exception, Object[] args) {
        event.setException(exception);
        recorder.add(event);
        ServletHooks.stopRecording(event, null, exception);
    }
}

