/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.test.util;

import com.appland.appmap.test.util.AnnotationBuilder;
import com.appland.appmap.test.util.ClassBuilder;
import com.appland.appmap.test.util.ParameterBuilder;
import com.appland.shade.javassist.CannotCompileException;
import com.appland.shade.javassist.ClassPool;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.javassist.CtMethod;
import com.appland.shade.javassist.CtNewMethod;
import com.appland.shade.javassist.NotFoundException;
import com.appland.shade.javassist.bytecode.AnnotationsAttribute;
import com.appland.shade.javassist.bytecode.CodeAttribute;
import com.appland.shade.javassist.bytecode.ConstPool;
import com.appland.shade.javassist.bytecode.Descriptor;
import com.appland.shade.javassist.bytecode.LocalVariableAttribute;
import com.appland.shade.javassist.bytecode.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public class MethodBuilder {
    private ClassBuilder declaringClassBuilder;
    private List<CtClass> exceptions = new ArrayList<CtClass>();
    private CtClass returnType = CtClass.voidType;
    private String name;
    private String body = "{ }";
    private Integer modifiers = 1;
    private List<ParameterBuilder> parameters = new ArrayList<ParameterBuilder>();
    private List<AnnotationBuilder> annotations = new ArrayList<AnnotationBuilder>();

    public MethodBuilder(ClassBuilder declaringClassBuilder) {
        this.declaringClassBuilder = declaringClassBuilder;
    }

    public MethodBuilder setBody(String body) {
        this.body = body;
        return this;
    }

    public MethodBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public MethodBuilder setReturnType(CtClass returnType) {
        this.returnType = returnType;
        return this;
    }

    public MethodBuilder setReturnType(String returnTypeName) throws NotFoundException {
        this.setReturnType(ClassPool.getDefault().get(returnTypeName));
        return this;
    }

    public MethodBuilder addException(CtClass exceptionType) {
        this.exceptions.add(exceptionType);
        return this;
    }

    public MethodBuilder addException(String exceptionTypeName) throws NotFoundException {
        this.addException(ClassPool.getDefault().get(exceptionTypeName));
        return this;
    }

    public MethodBuilder addModifer(Integer modifier) {
        MethodBuilder methodBuilder = this;
        methodBuilder.modifiers = methodBuilder.modifiers | modifier;
        return this;
    }

    public MethodBuilder addParameter(CtClass parameterType, String parameterId) {
        this.beginParameter().setType(parameterType).setId(parameterId).endParameter();
        return this;
    }

    public MethodBuilder addParameter(String parameterType, String parameterId) throws NotFoundException {
        this.beginParameter().setType(parameterType).setId(parameterId).endParameter();
        return this;
    }

    public ParameterBuilder beginParameter() {
        ParameterBuilder builder = new ParameterBuilder(this);
        this.parameters.add(builder);
        return builder;
    }

    public AnnotationBuilder beginAnnotation() {
        AnnotationBuilder builder = new AnnotationBuilder(this);
        this.annotations.add(builder);
        return builder;
    }

    public AnnotationBuilder beginAnnotation(String annotationType) {
        return this.beginAnnotation().setType(annotationType);
    }

    public MethodBuilder addAnnotation(String annotationType) {
        return this.beginAnnotation(annotationType).endAnnotation();
    }

    public ClassBuilder endMethod() throws CannotCompileException {
        this.build();
        return this.declaringClassBuilder;
    }

    private CtMethod build() throws CannotCompileException {
        CtClass[] parameters = (CtClass[])this.parameters.stream().map(p -> p.getType()).toArray(CtClass[]::new);
        Integer paramIndex = 1;
        for (ParameterBuilder parameterBuilder : this.parameters) {
            this.body = parameterBuilder.getType().getName() + " " + parameterBuilder.getId() + " = $" + paramIndex + "; " + this.body;
            paramIndex = paramIndex + 1;
        }
        this.body = "{ " + this.body + " }";
        CtClass[] exceptions = new CtClass[this.exceptions.size()];
        this.exceptions.toArray(exceptions);
        CtMethod method = CtNewMethod.make(this.modifiers, this.returnType, this.name, parameters, exceptions, this.body, this.declaringClassBuilder.ctClass());
        CodeAttribute codeAttribute = method.getMethodInfo().getCodeAttribute();
        ConstPool constPool = method.getMethodInfo().getConstPool();
        LocalVariableAttribute locals = new LocalVariableAttribute(constPool);
        paramIndex = 1;
        for (ParameterBuilder parameterBuilder : this.parameters) {
            Integer nameIndex = constPool.addUtf8Info(parameterBuilder.getId());
            Integer descIndex = constPool.addUtf8Info(Descriptor.of(parameterBuilder.getType()));
            locals.addEntry(0, codeAttribute.getCodeLength(), nameIndex, descIndex, paramIndex);
            paramIndex = paramIndex + 1;
        }
        codeAttribute.getAttributes().add(locals);
        AnnotationsAttribute annotationAttribute = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        for (AnnotationBuilder annotationBuilder : this.annotations) {
            Annotation annotation = annotationBuilder.build(constPool);
            annotationAttribute.addAnnotation(annotation);
        }
        method.getMethodInfo().addAttribute(annotationAttribute);
        this.declaringClassBuilder.ctClass().addMethod(method);
        return method;
    }
}

