/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform.annotations;

import com.appland.appmap.transform.annotations.AnnotationUtil;
import com.appland.appmap.transform.annotations.CtClassUtil;
import com.appland.appmap.transform.annotations.HookClass;
import com.appland.appmap.transform.annotations.ISystem;
import com.appland.appmap.transform.annotations.IgnoreChildren;
import com.appland.appmap.transform.annotations.SourceMethodSystem;
import com.appland.appmap.util.Logger;
import com.appland.shade.javassist.CtBehavior;

public class HookClassSystem
extends SourceMethodSystem {
    private static final Boolean IGNORE_CHILDREN_DEFAULT = false;
    private String targetClass = null;
    private String targetMethod = null;
    private Boolean ignoresChildren = IGNORE_CHILDREN_DEFAULT;
    private final Integer position;

    private HookClassSystem(CtBehavior behavior, int position) {
        super(behavior, HookClass.class);
        this.position = position;
    }

    public static ISystem from(CtBehavior behavior) {
        try {
            HookClass hookClass = (HookClass)behavior.getAnnotation(HookClass.class);
            if (hookClass == null) {
                hookClass = (HookClass)behavior.getDeclaringClass().getAnnotation(HookClass.class);
            }
            if (hookClass == null) {
                return null;
            }
            if (hookClass.value() == null) {
                return null;
            }
            Boolean ignoresChildren = (Boolean)AnnotationUtil.getValue(behavior, IgnoreChildren.class, IGNORE_CHILDREN_DEFAULT);
            Integer position = AnnotationUtil.getPosition(behavior, HookClass.class, 0);
            HookClassSystem system = new HookClassSystem(behavior, position);
            system.ignoresChildren = ignoresChildren;
            system.targetClass = hookClass.value();
            system.targetMethod = hookClass.method() == null || hookClass.method().isEmpty() ? behavior.getName() : hookClass.method();
            return system;
        }
        catch (Exception e) {
            Logger.println(e);
            return null;
        }
    }

    @Override
    public Boolean match(CtBehavior behavior) {
        if (this.ignoresChildren != false ? !behavior.getDeclaringClass().getName().equals(this.targetClass) : CtClassUtil.isChildOf(behavior.getDeclaringClass(), this.targetClass) == false) {
            return false;
        }
        if (!behavior.getName().equals(this.targetMethod)) {
            return false;
        }
        return true;
    }

    @Override
    public String getKey() {
        return this.targetMethod;
    }

    @Override
    public Integer getHookPosition() {
        return this.position;
    }
}

