/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.config;

import com.appland.appmap.config.AppMapPackage;
import com.appland.appmap.util.Logger;
import com.appland.shade.org.yaml.snakeyaml.Yaml;
import com.appland.shade.org.yaml.snakeyaml.constructor.Constructor;
import com.appland.shade.org.yaml.snakeyaml.error.YAMLException;
import com.appland.shade.org.yaml.snakeyaml.representer.Representer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class AppMapConfig {
    public File configFile;
    public String name;
    public AppMapPackage[] packages = new AppMapPackage[0];
    private static AppMapConfig singleton = new AppMapConfig();

    static File findConfig(File configFile) throws FileNotFoundException {
        if (configFile.exists()) {
            return configFile;
        }
        for (Path parent = configFile.toPath().toAbsolutePath().getParent(); parent != null; parent = parent.getParent()) {
            Path c = parent.resolve("appmap.yml");
            if (!Files.exists(c, new LinkOption[0])) continue;
            return c.toFile();
        }
        throw new FileNotFoundException(configFile.toString());
    }

    public static AppMapConfig load(File configFile) {
        FileInputStream inputStream = null;
        try {
            configFile = AppMapConfig.findConfig(configFile);
            Logger.println(String.format("using config file -> %s", configFile.getAbsolutePath()));
            inputStream = new FileInputStream(configFile);
        }
        catch (FileNotFoundException e) {
            String expectedConfig = configFile.getAbsolutePath();
            Logger.println(String.format("error: file not found -> %s", expectedConfig));
            Logger.error(String.format("error: file not found -> %s", expectedConfig));
            return null;
        }
        Representer representer = new Representer();
        representer.getPropertyUtils().setSkipMissingProperties(true);
        Yaml yaml = new Yaml(new Constructor(AppMapConfig.class), representer);
        try {
            singleton = (AppMapConfig)yaml.load(inputStream);
        }
        catch (YAMLException e) {
            Logger.error("AppMap: encountered syntax error in appmap.yml " + e.getMessage());
            System.exit(1);
        }
        AppMapConfig.singleton.configFile = configFile;
        return singleton;
    }

    public static AppMapConfig get() {
        return singleton;
    }

    public Boolean includes(String canonicalName) {
        if (this.packages == null) {
            return false;
        }
        for (AppMapPackage pkg : this.packages) {
            if (!pkg.includes(canonicalName).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean excludes(String canonicalName) {
        if (this.packages == null) {
            return false;
        }
        for (AppMapPackage pkg : this.packages) {
            if (!pkg.excludes(canonicalName).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isShallow(String canonicalName) {
        if (canonicalName == null) {
            return false;
        }
        for (AppMapPackage pkg : this.packages) {
            if (!pkg.includes(canonicalName).booleanValue()) continue;
            return pkg.shallow;
        }
        return false;
    }
}

