/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks.remoterecording;

import com.appland.appmap.config.Properties;
import com.appland.appmap.output.v1.Event;
import com.appland.appmap.process.ExitEarly;
import com.appland.appmap.process.hooks.remoterecording.HttpCoreRequest;
import com.appland.appmap.process.hooks.remoterecording.RemoteRecordingManager;
import com.appland.appmap.transform.annotations.ArgumentArray;
import com.appland.appmap.transform.annotations.ExcludeReceiver;
import com.appland.appmap.transform.annotations.HookClass;
import com.appland.appmap.util.Logger;
import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.BasicAsyncResponseProducer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.nio.protocol.HttpAsyncResponseProducer;
import org.apache.http.protocol.HttpContext;

public class HttpCoreAsyncHooks {
    private static final boolean debug = Properties.DebugHttp;

    @ArgumentArray
    @ExcludeReceiver
    @HookClass(value="org.apache.http.nio.protocol.HttpAsyncRequestHandlerMapper")
    public static void lookup(Event event, Object[] args) throws ExitEarly {
        HttpRequest req = (HttpRequest)args[0];
        if (debug) {
            Logger.println("HttpCoreAsyncRequestHandler.lookup: " + req);
        }
        if (req.getRequestLine().getUri().startsWith("/_appmap/record")) {
            throw new ExitEarly(new AppMapHandler());
        }
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookClass(value="org.apache.http.nio.protocol.BasicAsyncRequestHandler", method="handle")
    public static void handleAsync(Event event, Object[] args) throws IOException, HttpException, ExitEarly {
        HttpRequest req = (HttpRequest)args[0];
        HttpAsyncExchange httpexchange = (HttpAsyncExchange)args[1];
        HttpResponse res = httpexchange.getResponse();
        boolean handled = RemoteRecordingManager.service(new HttpCoreRequest(req, res));
        if (handled) {
            httpexchange.submitResponse((HttpAsyncResponseProducer)new BasicAsyncResponseProducer(res));
            throw new ExitEarly();
        }
    }

    static class AppMapHandler
    implements HttpAsyncRequestHandler<HttpRequest> {
        AppMapHandler() {
        }

        public HttpAsyncRequestConsumer<HttpRequest> processRequest(HttpRequest request, HttpContext context) {
            return new BasicAsyncRequestConsumer();
        }

        public void handle(HttpRequest request, HttpAsyncExchange httpexchange, HttpContext context) throws HttpException, IOException {
            HttpResponse response = httpexchange.getResponse();
            RemoteRecordingManager.service(new HttpCoreRequest(request, response));
            httpexchange.submitResponse((HttpAsyncResponseProducer)new BasicAsyncResponseProducer(response));
        }
    }
}

