/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform.annotations;

import com.appland.appmap.output.v1.Parameters;
import com.appland.appmap.output.v1.Value;
import com.appland.appmap.transform.annotations.AnnotationUtil;
import com.appland.appmap.transform.annotations.BaseSystem;
import com.appland.appmap.transform.annotations.HookBinding;
import com.appland.appmap.transform.annotations.MethodEvent;
import com.appland.appmap.util.Logger;
import com.appland.shade.javassist.CtBehavior;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.javassist.CtMethod;
import com.appland.shade.javassist.NotFoundException;

public abstract class SourceMethodSystem
extends BaseSystem {
    public static final String EVENT_TOKEN = "$evt";
    private String hookClass;
    private String hookMethod;
    private MethodEvent methodEvent;

    protected SourceMethodSystem(CtBehavior behavior, Class annotationClass) {
        super(behavior);
        this.hookClass = behavior.getDeclaringClass().getName();
        this.hookMethod = behavior.getName();
        this.methodEvent = (MethodEvent)((Object)AnnotationUtil.getObject(behavior, annotationClass, "methodEvent", (Object)MethodEvent.METHOD_INVOCATION));
    }

    @Override
    public Boolean match(CtBehavior behavior) {
        return false;
    }

    public String getKey() {
        return null;
    }

    public String toString() {
        return String.format("%s.%s", this.hookClass, this.hookMethod);
    }

    @Override
    public void mutateStaticParameters(CtBehavior hookBehavior, Parameters hookParameters) {
        hookParameters.add(new Value().setName(EVENT_TOKEN));
    }

    @Override
    public void mutateRuntimeParameters(HookBinding binding, Parameters runtimeParameters) {
        if (this.methodEvent == MethodEvent.METHOD_RETURN) {
            CtBehavior targetBehavior = binding.getTargetBehavior();
            if (targetBehavior.getMethodInfo().isMethod()) {
                try {
                    CtMethod method = (CtMethod)targetBehavior;
                    CtClass returnType = method.getReturnType();
                    Value returnValue = new Value();
                    if (returnType == CtClass.voidType) {
                        returnValue.setName("null");
                    } else {
                        returnValue.setName("com.appland.appmap.process.RuntimeUtil.boxValue($_)");
                    }
                    runtimeParameters.add(returnValue);
                }
                catch (NotFoundException e) {
                    Logger.println("warning - unknown return type");
                    Logger.println(e);
                }
            }
        } else if (this.methodEvent == MethodEvent.METHOD_EXCEPTION) {
            runtimeParameters.add(new Value().setClassType("java.lang.Exception").setName("$e"));
        }
    }

    public MethodEvent getMethodEvent() {
        return this.methodEvent;
    }

    @Override
    public Integer getParameterPriority() {
        return 200;
    }

    @Override
    public Integer getHookPosition() {
        MethodEvent methodEvent = this.getMethodEvent();
        switch (methodEvent) {
            case METHOD_INVOCATION: {
                return -1;
            }
            case METHOD_RETURN: 
            case METHOD_EXCEPTION: {
                return 1;
            }
        }
        throw new RuntimeException("Unknown MethodEvent type (" + methodEvent.getEventString() + "," + methodEvent.getIndex() + ")");
    }
}

