/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks;

import com.appland.appmap.output.v1.Event;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.transform.annotations.ExcludeReceiver;
import com.appland.appmap.transform.annotations.HookClass;
import com.appland.appmap.transform.annotations.MethodEvent;
import com.appland.appmap.util.Logger;
import java.util.Map;

public class Message {
    private static final Recorder recorder = Recorder.getInstance();

    @ExcludeReceiver
    @HookClass(value="org.springframework.util.PathMatcher", methodEvent=MethodEvent.METHOD_RETURN)
    public static void extractUriTemplateVariables(Event event, Object returnVal, String pattern, String path) {
        Event lastEvent = recorder.getLastEvent();
        if (lastEvent == null) {
            return;
        }
        if (lastEvent.httpServerRequest == null) {
            return;
        }
        if (lastEvent.frozen()) {
            Logger.printf("Won't set message params or normalized path on event %d because it's already frozen\n", lastEvent.id);
            return;
        }
        Message.addMessageParams(returnVal, lastEvent);
        String normalizedPath = pattern.replace('{', ':').replace("}", "");
        lastEvent.httpServerRequest.setNormalizedPath(normalizedPath);
    }

    private static void addMessageParams(Object returnVal, Event lastEvent) {
        Map pathParams = (Map)returnVal;
        for (Map.Entry param : pathParams.entrySet()) {
            lastEvent.addMessageParam((String)param.getKey(), param.getValue());
        }
    }
}

