/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks.remoterecording;

import com.appland.appmap.config.Properties;
import com.appland.appmap.process.ExitEarly;
import com.appland.appmap.process.hooks.remoterecording.RemoteRecordingRequest;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.record.Recording;
import com.appland.appmap.util.Logger;
import java.io.IOException;

public class RemoteRecordingManager {
    private static final boolean debug = Properties.DebugHttp;
    private static final Recorder recorder = Recorder.getInstance();
    public static final String RecordRoute = "/_appmap/record";
    public static final String CheckpointRoute = "/_appmap/record/checkpoint";

    private static void doDelete(RemoteRecordingRequest req) throws IOException {
        if (debug) {
            Logger.println("RemoteRecordingManager.doDelete");
        }
        if (!recorder.hasActiveSession()) {
            req.setStatus(404);
            return;
        }
        Recording recording = recorder.stop();
        req.writeRecording(recording);
        req.setStatus(200);
    }

    private static void doGet(RemoteRecordingRequest req) throws IOException {
        if (debug) {
            Logger.println("RemoteRecordingManager.doGet");
        }
        String responseJson = String.format("{\"enabled\":%b}", recorder.hasActiveSession());
        req.writeJson(responseJson);
        req.setStatus(200);
    }

    private static void doPost(RemoteRecordingRequest req) {
        if (debug) {
            Logger.println("RemoteRecordingManager.doPost");
        }
        if (recorder.hasActiveSession()) {
            req.setStatus(409);
            return;
        }
        Recorder.Metadata metadata = new Recorder.Metadata();
        metadata.recorderName = "remote_recording";
        recorder.start(metadata);
        req.setStatus(200);
    }

    private static void doCheckpoint(RemoteRecordingRequest req) throws IOException {
        if (debug) {
            Logger.println("RemoteRecordingManager.doCheckpoint");
        }
        if (!recorder.hasActiveSession()) {
            req.setStatus(404);
            return;
        }
        Recording recording = recorder.checkpoint();
        req.writeRecording(recording);
        req.setStatus(200);
    }

    private static void handleRecordRequest(RemoteRecordingRequest req, HandlerFunction fn) throws ExitEarly {
        try {
            fn.call(req);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean service(RemoteRecordingRequest req) {
        boolean handled = false;
        if (debug) {
            Logger.printf("RemoteRecordingManager.service - handling appmap request for %s\n", req);
            Logger.whereAmI();
        }
        Logger.println("service, ret.getRequestUri(): " + req.getRequestURI());
        if (req.getRequestURI().endsWith(CheckpointRoute)) {
            if (req.getMethod().equals("GET")) {
                RemoteRecordingManager.handleRecordRequest(req, RemoteRecordingManager::doCheckpoint);
                handled = true;
            }
        } else if (req.getRequestURI().endsWith(RecordRoute)) {
            if (req.getMethod().equals("GET")) {
                RemoteRecordingManager.handleRecordRequest(req, RemoteRecordingManager::doGet);
                handled = true;
            } else if (req.getMethod().equals("POST")) {
                RemoteRecordingManager.handleRecordRequest(req, RemoteRecordingManager::doPost);
                handled = true;
            } else if (req.getMethod().equals("DELETE")) {
                RemoteRecordingManager.handleRecordRequest(req, RemoteRecordingManager::doDelete);
                handled = true;
            }
        }
        if (debug) {
            Logger.println("RemoteRecordingManager.service - handled appmap request? " + handled);
        }
        return handled;
    }

    static interface HandlerFunction {
        public void call(RemoteRecordingRequest var1) throws IOException;
    }
}

