/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform;

import com.appland.appmap.config.Properties;
import com.appland.appmap.output.v1.NoSourceAvailableException;
import com.appland.appmap.transform.annotations.Hook;
import com.appland.appmap.transform.annotations.HookSite;
import com.appland.appmap.transform.annotations.HookValidationException;
import com.appland.appmap.util.AppMapBehavior;
import com.appland.appmap.util.Logger;
import com.appland.shade.javassist.ClassPool;
import com.appland.shade.javassist.CtBehavior;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.javassist.CtMethod;
import com.appland.shade.javassist.LoaderClassPath;
import com.appland.shade.javassist.Modifier;
import com.appland.shade.javassist.NotFoundException;
import com.appland.shade.javassist.bytecode.Descriptor;
import com.appland.shade.org.reflections.Reflections;
import com.appland.shade.org.reflections.scanners.SubTypesScanner;
import com.appland.shade.org.reflections.util.ClasspathHelper;
import com.appland.shade.org.reflections.util.ConfigurationBuilder;
import com.appland.shade.org.reflections.util.FilterBuilder;
import java.io.ByteArrayInputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClassFileTransformer
implements java.lang.instrument.ClassFileTransformer {
    private static final List<Hook> unkeyedHooks = new ArrayList<Hook>();
    private static final Map<String, List<Hook>> keyedHooks = new HashMap<String, List<Hook>>();

    public ClassFileTransformer() {
        Reflections reflections = new Reflections(new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage("com.appland.appmap.process", new ClassLoader[0])).setScanners(new SubTypesScanner(false)).filterInputsBy(new FilterBuilder().includePackage("com.appland.appmap.process")));
        ClassPool classPool = ClassPool.getDefault();
        for (Class<Object> classType : reflections.getSubTypesOf(Object.class)) {
            try {
                CtClass ctClass = classPool.get(classType.getName());
                this.processClass(ctClass);
                ctClass.detach();
            }
            catch (NotFoundException e) {
                Logger.printf("failed to find %s in class pool", classType.getName());
                Logger.println(e);
            }
        }
    }

    private void addHook(Hook hook) {
        if (hook == null) {
            return;
        }
        String key = hook.getKey();
        if (Properties.DebugHooks.booleanValue()) {
            Logger.printf("%s: %s\n", key, hook);
        }
        if (key == null) {
            unkeyedHooks.add(hook);
        } else {
            List matchingKeyedHooks = keyedHooks.computeIfAbsent(key, k -> new ArrayList());
            matchingKeyedHooks.add(hook);
        }
    }

    private List<Hook> getHooks(String methodId) {
        List<Hook> matchingKeyedHooks = keyedHooks.get(methodId);
        if (matchingKeyedHooks == null) {
            matchingKeyedHooks = new ArrayList<Hook>();
        }
        return Stream.of(matchingKeyedHooks, unkeyedHooks).flatMap(Collection::stream).sorted(Comparator.comparingInt(Hook::getPosition)).collect(Collectors.toList());
    }

    private void processClass(CtClass ctClass) {
        for (CtBehavior behavior : ctClass.getDeclaredBehaviors()) {
            Hook hook = Hook.from(behavior);
            if (hook == null) continue;
            ctClass.defrost();
            try {
                hook.validate();
            }
            catch (HookValidationException e) {
                Logger.println("failed to validate hook");
                Logger.println(e);
                continue;
            }
            this.addHook(hook);
            if (!Properties.DebugHooks.booleanValue()) continue;
            Logger.printf("registered hook %s\n", hook.toString());
        }
    }

    private void applyHooks(CtBehavior behavior) {
        try {
            List<HookSite> hookSites = this.getHooks(behavior.getName()).stream().map(hook -> hook.prepare(behavior)).filter(Objects::nonNull).collect(Collectors.toList());
            if (hookSites.size() < 1) {
                return;
            }
            Hook.apply(behavior, hookSites);
            if (Properties.DebugHooks.booleanValue()) {
                for (HookSite hookSite : hookSites) {
                    Hook hook2 = hookSite.getHook();
                    Logger.printf("hooked %s.%s%s on (%s,%d) with %s\n", behavior.getDeclaringClass().getName(), behavior.getName(), behavior.getMethodInfo().getDescriptor(), hook2.getMethodEvent().getEventString(), hook2.getPosition(), hook2);
                }
            }
        }
        catch (NoSourceAvailableException e) {
            Logger.println(e);
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> redefiningClass, ProtectionDomain domain, byte[] bytes) throws IllegalClassFormatException {
        ClassPool classPool = new ClassPool();
        classPool.appendClassPath(new LoaderClassPath(loader));
        try {
            CtClass ctClass;
            try {
                ctClass = classPool.makeClass(new ByteArrayInputStream(bytes));
            }
            catch (RuntimeException e) {
                Logger.printf("Skipping class %s, failed making a new one: %s\n", className, e.getMessage());
                return bytes;
            }
            if (ctClass.isInterface()) {
                return bytes;
            }
            for (CtBehavior behavior : ctClass.getDeclaredBehaviors()) {
                if (this.ignoreMethod(behavior)) continue;
                this.applyHooks(behavior);
            }
            return ctClass.toBytecode();
        }
        catch (Exception e) {
            Logger.println("An error occurred transforming class " + className);
            Logger.println(e.getClass() + ": " + e.getMessage());
            e.printStackTrace(System.err);
            return bytes;
        }
    }

    private boolean ignoreMethod(CtBehavior behavior) {
        if (!(behavior instanceof CtMethod)) {
            return false;
        }
        CtMethod method = (CtMethod)behavior;
        try {
            return behavior.getMethodInfo2().isConstructor() || behavior.getMethodInfo2().isStaticInitializer() || ClassFileTransformer.isGetter(method) || ClassFileTransformer.isSetter(method) || this.isIgnoredInstanceMethod(method);
        }
        catch (NotFoundException e) {
            Logger.println(e);
            return true;
        }
    }

    private boolean isIgnoredInstanceMethod(CtMethod method) {
        int mods = method.getModifiers();
        if (Modifier.isStatic(mods) || !new AppMapBehavior(method).isRecordable().booleanValue()) {
            return false;
        }
        String methodName = method.getName();
        return methodName.equals("equals") || methodName.equals("hashCode") || methodName.equals("iterator") || methodName.equals("toString");
    }

    public static boolean isGetter(CtMethod method) throws NotFoundException {
        String descriptor = method.getMethodInfo().getDescriptor();
        String methodName = method.getName();
        if (new AppMapBehavior(method).isRecordable().booleanValue() && Descriptor.numOfParameters(descriptor) == 0) {
            if (methodName.matches("^get[A-Z].*") && !descriptor.matches("\\)V$")) {
                return true;
            }
            if (methodName.matches("^is[A-Z].*") && descriptor.matches("\\)Z$")) {
                return true;
            }
            return methodName.matches("^has[A-Z].*") && descriptor.matches("\\)Z$");
        }
        return false;
    }

    public static boolean isSetter(CtMethod method) throws NotFoundException {
        String descriptor = method.getMethodInfo().getDescriptor();
        return new AppMapBehavior(method).isRecordable() != false && descriptor.matches("\\)V$") && Descriptor.numOfParameters(descriptor) == 1 && method.getName().matches("^set[A-Z].*");
    }
}

