/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.output.v1;

import com.appland.appmap.config.Properties;
import com.appland.appmap.output.v1.NoSourceAvailableException;
import com.appland.appmap.output.v1.Value;
import com.appland.appmap.util.Logger;
import com.appland.shade.javassist.CtBehavior;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.javassist.NotFoundException;
import com.appland.shade.javassist.bytecode.CodeAttribute;
import com.appland.shade.javassist.bytecode.LocalVariableAttribute;
import com.appland.shade.javassist.bytecode.MethodInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Parameters
implements Iterable<Value> {
    private final ArrayList<Value> values = new ArrayList();

    public Parameters() {
    }

    public Parameters(CtBehavior behavior) {
        int i;
        MethodInfo methodInfo = behavior.getMethodInfo();
        String fqn = behavior.getDeclaringClass().getName() + "." + behavior.getName() + methodInfo.getDescriptor();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute == null) {
            throw new NoSourceAvailableException("No code attribute for " + fqn);
        }
        LocalVariableAttribute locals = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
        CtClass[] paramTypes = null;
        try {
            paramTypes = behavior.getParameterTypes();
        }
        catch (NotFoundException e) {
            throw new NoSourceAvailableException(String.format("Failed to get parameter types for %s: %s", fqn, e.getMessage()));
        }
        String[] paramNames = null;
        int numParams = paramTypes.length;
        if (locals != null && numParams > 0) {
            int localVarIdx;
            int numLocals = locals.tableLength();
            if (Properties.DebugLocals.booleanValue()) {
                Logger.println("local variables for " + fqn);
                for (int idx = 0; idx < numLocals; ++idx) {
                    Logger.printf("  %d %s %d\n", idx, locals.variableName(idx), locals.index(idx));
                }
            }
            paramNames = new String[numParams];
            Boolean isStatic = (behavior.getModifiers() & 8) != 0;
            int firstParamIdx = isStatic != false ? 0 : 1;
            for (localVarIdx = 0; localVarIdx < numLocals && locals.index(localVarIdx) != firstParamIdx; ++localVarIdx) {
            }
            if (localVarIdx < numLocals) {
                paramNames[0] = locals.variableName(localVarIdx);
                for (int idx = 1; idx < numParams; ++idx) {
                    paramNames[idx] = locals.variableName(localVarIdx + idx);
                }
            }
        }
        Value[] paramValues = new Value[numParams];
        for (i = 0; i < paramTypes.length; ++i) {
            Value param;
            String paramName = paramNames != null ? paramNames[i] : "p" + i;
            paramValues[i] = param = new Value().setClassType(paramTypes[i].getName()).setName(paramName).setKind("req");
        }
        for (i = 0; i < paramValues.length; ++i) {
            this.add(paramValues[i]);
        }
    }

    @Override
    public Iterator<Value> iterator() {
        return this.values.iterator();
    }

    public boolean add(Value param) {
        if (param == null) {
            return false;
        }
        return this.values.add(param);
    }

    public Stream<Value> stream() {
        return this.values.stream();
    }

    public int size() {
        return this.values.size();
    }

    public void clear() {
        this.values.clear();
    }

    public Value get(String name) throws NoSuchElementException {
        if (this.values != null) {
            for (Value param : this.values) {
                if (!param.name.equals(name)) continue;
                return param;
            }
        }
        throw new NoSuchElementException();
    }

    public Value get(Integer index) throws NoSuchElementException {
        if (this.values == null) {
            throw new NoSuchElementException();
        }
        try {
            return this.values.get(index);
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            throw new NoSuchElementException();
        }
    }

    public Boolean validate(Integer index, String type) {
        try {
            Value param = this.get(index);
            return param.classType.equals(type);
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public Parameters clone() {
        Parameters clonedParams = new Parameters();
        for (Value param : this.values) {
            clonedParams.add(new Value(param));
        }
        return clonedParams;
    }

    public String toString() {
        return this.values.stream().map(value -> value.classType).collect(Collectors.joining(", "));
    }
}

