/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.output.v1;

import com.appland.appmap.output.v1.CodeObject;
import com.appland.appmap.output.v1.ExceptionValue;
import com.appland.appmap.output.v1.HttpClientRequest;
import com.appland.appmap.output.v1.HttpClientResponse;
import com.appland.appmap.output.v1.HttpServerRequest;
import com.appland.appmap.output.v1.HttpServerResponse;
import com.appland.appmap.output.v1.Parameters;
import com.appland.appmap.output.v1.SqlQuery;
import com.appland.appmap.output.v1.Value;
import com.appland.appmap.util.FullyQualifiedName;
import com.appland.shade.com.alibaba.fastjson.annotation.JSONField;
import com.appland.shade.javassist.CtBehavior;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class Event {
    private static Integer globalEventId = 0;
    public Integer id;
    public String event;
    public String path;
    public Value receiver;
    public Parameters parameters;
    private FullyQualifiedName fqn;
    @JSONField(name="defined_class")
    public String definedClass;
    @JSONField(name="method_id")
    public String methodId;
    @JSONField(name="lineno")
    public Integer lineNumber;
    @JSONField(name="thread_id")
    public Long threadId;
    @JSONField(name="parent_id")
    public Integer parentId;
    @JSONField(name="static")
    public Boolean isStatic;
    @JSONField(name="return_value")
    public Value returnValue;
    public ArrayList<ExceptionValue> exceptions;
    @JSONField(name="http_server_request")
    public HttpServerRequest httpServerRequest;
    @JSONField(name="http_server_response")
    public HttpServerResponse httpServerResponse;
    @JSONField(name="http_client_request")
    public HttpClientRequest httpClientRequest;
    @JSONField(name="http_client_response")
    public HttpClientResponse httpClientResponse;
    public ArrayList<Value> message;
    @JSONField(name="sql_query")
    public SqlQuery sqlQuery;
    @JSONField(name="elapsed")
    public Float elapsed = null;
    private boolean frozen = false;
    private boolean ignored = false;
    private String packageName;
    private LocalDateTime startTime;

    private synchronized Integer issueId() {
        globalEventId = globalEventId + 1;
        return globalEventId;
    }

    public static Event functionCallEvent(Event master) {
        return new Event().fqn(master.fqn).setEvent("call").setThreadId(Thread.currentThread().getId()).setDefinedClass(master.definedClass).setMethodId(master.methodId).setPath(master.path).setLineNumber(master.lineNumber).setStatic(master.isStatic);
    }

    public static Event functionReturnEvent(Event master) {
        return new Event().setEvent("return").fqn(master.fqn).setDefinedClass(master.definedClass).setStatic(master.isStatic).setMethodId(master.methodId);
    }

    public Event() {
        this.setId(this.issueId());
    }

    public Event(CtBehavior behavior) {
        this.fqn(behavior).setDefinedClass(behavior.getDeclaringClass().getName()).setMethodId(behavior.getName()).setStatic((behavior.getModifiers() & 8) != 0).setPath(CodeObject.getSourceFilePath(behavior.getDeclaringClass())).setLineNumber(behavior.getMethodInfo().getLineNumber(0)).setParameters(new Parameters(behavior));
    }

    private Event setId(Integer id) {
        this.id = id;
        return this;
    }

    public boolean frozen() {
        return this.frozen;
    }

    public void ignore() {
        this.ignored = true;
    }

    public boolean ignored() {
        return this.ignored;
    }

    public boolean hasPackageName() {
        return this.packageName != null;
    }

    public String packageName() {
        return this.packageName;
    }

    public FullyQualifiedName fqn() {
        return this.fqn;
    }

    public Event fqn(CtBehavior behavior) {
        this.fqn = new FullyQualifiedName(behavior);
        return this;
    }

    public Event fqn(FullyQualifiedName fqn) {
        this.fqn = new FullyQualifiedName(fqn);
        return this;
    }

    public Event setEvent(String event) {
        this.event = event;
        return this;
    }

    public Event setPath(String path) {
        this.path = path;
        return this;
    }

    public Event setDefinedClass(String definedClass) {
        this.definedClass = definedClass;
        String[] tokens = definedClass.split("\\.");
        this.packageName = String.join((CharSequence)".", Arrays.copyOf(tokens, tokens.length - 1));
        return this;
    }

    public Event setMethodId(String methodId) {
        this.methodId = methodId;
        return this;
    }

    public Event setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
        return this;
    }

    public Event setThreadId(Long threadId) {
        this.threadId = threadId;
        return this;
    }

    public Event setParentId(Integer parentId) {
        this.parentId = parentId;
        return this;
    }

    public Event setStatic(Boolean val) {
        this.isStatic = val;
        return this;
    }

    public Event setReturnValue(Object val) {
        if (val != null) {
            this.returnValue = new Value(val);
        }
        return this;
    }

    public Event setException(Exception exception) {
        if (exception != null) {
            this.exceptions = new ArrayList();
            for (Throwable t = exception; t != null; t = t.getCause()) {
                this.exceptions.add(new ExceptionValue(t));
            }
        }
        return this;
    }

    public Event setReceiver(Object val) {
        if (val != null) {
            this.receiver = new Value(val);
        }
        return this;
    }

    public Event addParameter(Object val, String name) {
        if (this.parameters == null) {
            this.parameters = new Parameters();
        }
        this.parameters.add(new Value(val, name));
        return this;
    }

    public Event addParameter(Value val) {
        if (this.parameters == null) {
            this.parameters = new Parameters();
        }
        this.parameters.add(new Value(val));
        return this;
    }

    public Event setParameters(Parameters parameters) {
        this.parameters = parameters;
        return this;
    }

    public Event setHttpServerRequest(String method, String path, String protocol, Map<String, String> headers) {
        this.clearFunctionFields();
        this.httpServerRequest = new HttpServerRequest().setMethod(method).setPath(path).setProtocol(protocol).setHeaders(headers);
        return this;
    }

    public Event setHttpServerResponse(Integer status) {
        this.httpServerResponse = new HttpServerResponse().setStatus(status);
        return this;
    }

    public Event setHttpServerResponse(Integer status, Map<String, String> headers) {
        this.httpServerResponse = new HttpServerResponse().setStatus(status).setHeaders(headers);
        return this;
    }

    public Event setHttpClientRequest(String method, String path, String protocol) {
        this.clearFunctionFields();
        this.httpClientRequest = new HttpClientRequest().setMethod(method).setPath(path).setProtocol(protocol);
        return this;
    }

    public Event setHttpClientResponse(Integer status, String mimeType) {
        this.httpClientResponse = new HttpClientResponse().setStatus(status).setMimeType(mimeType);
        return this;
    }

    public Event addMessageParam(Value val) {
        if (this.message == null) {
            this.message = new ArrayList();
        }
        this.message.add(val);
        return this;
    }

    public Event addMessageParam(String name, Object val) {
        Value valObject = new Value(val, name);
        this.addMessageParam(valObject);
        return this;
    }

    public Event setSqlQuery(String databaseType, String sql) {
        this.clearFunctionFields();
        this.sqlQuery = new SqlQuery(databaseType, sql);
        return this;
    }

    public Event setStartTime() {
        this.startTime = LocalDateTime.now();
        return this;
    }

    public Event measureElapsed(Event callEvent) {
        LocalDateTime endTime = LocalDateTime.now();
        double duration = (double)Duration.between(callEvent.startTime, endTime).toNanos() / 1.0E10;
        this.elapsed = Float.valueOf((float)duration);
        return this;
    }

    public Event freeze() {
        if (this.frozen) {
            return this;
        }
        if (this.parameters != null) {
            for (Value value : this.parameters) {
                value.freeze();
            }
        }
        if (this.receiver != null) {
            this.receiver.freeze();
        }
        if (this.returnValue != null) {
            this.returnValue.freeze();
        }
        if (this.exceptions != null) {
            for (ExceptionValue e : this.exceptions) {
                e.freeze();
            }
        }
        this.frozen = true;
        return this;
    }

    public void defrost() {
        this.frozen = false;
    }

    void clearFunctionFields() {
        this.methodId = null;
        this.definedClass = null;
        this.path = null;
        this.lineNumber = null;
        this.isStatic = null;
    }
}

