/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.record;

import com.appland.appmap.output.v1.CodeObject;
import java.util.List;

public class CodeObjectTree {
    private CodeObject root = new CodeObject();

    private void add(CodeObject rootObject, List<CodeObject> newObjects) {
        for (CodeObject newObject : newObjects) {
            this.add(rootObject, newObject);
        }
    }

    private void add(CodeObject rootObject, CodeObject newObject) {
        for (CodeObject child : rootObject.safeGetChildren()) {
            if (!child.equals(newObject)) continue;
            this.add(child, newObject.safeGetChildren());
            return;
        }
        rootObject.addChild(newObject);
    }

    public void add(CodeObject newObject) {
        this.add(this.root, newObject);
    }

    public void clear() {
        this.root = new CodeObject();
    }

    private int countTokens(String s, char delim) {
        if (s.length() == 0) {
            return 0;
        }
        int start = 0;
        int end = 0;
        int count = 0;
        while ((end = s.indexOf(delim, start)) > 0) {
            start = end + 1;
            ++count;
        }
        return ++count;
    }

    public CodeObject getMethodBranch(String definedClass, String methodId, Boolean isStatic, Integer lineNumber) {
        CodeObject child;
        int tokenCount = this.countTokens(definedClass, '.');
        CodeObject[] codeObjects = new CodeObject[tokenCount + 1];
        int idx = 0;
        CodeObject currentObject = this.root;
        int start = 0;
        int end = 0;
        while ((end = definedClass.indexOf(46, start)) > 0) {
            child = currentObject.findChildBySubstring(definedClass, start, end);
            if (child == null) {
                return null;
            }
            start = end + 1;
            codeObjects[idx++] = currentObject = child;
        }
        assert (definedClass.length() - start > 0) : "Not enough tokens";
        child = currentObject.findChildBySubstring(definedClass, start, definedClass.length());
        if (child == null) {
            return null;
        }
        codeObjects[idx++] = currentObject = child;
        CodeObject methodObject = currentObject.findChild(methodId, isStatic, lineNumber);
        if (methodObject == null) {
            return null;
        }
        codeObjects[idx] = methodObject;
        CodeObject rootObject = null;
        for (CodeObject codeObject : codeObjects) {
            CodeObject newObject = new CodeObject(codeObject);
            if (rootObject == null) {
                rootObject = newObject;
                currentObject = newObject;
                continue;
            }
            currentObject.addChild(newObject);
            currentObject = newObject;
        }
        return rootObject;
    }

    public Boolean isEmpty() {
        return this.root == null || this.root.safeGetChildren().size() < 1;
    }

    public CodeObject[] toArray() {
        List<CodeObject> children = this.root.safeGetChildren();
        Integer numTopLevelObjects = children.size();
        CodeObject[] codeObjects = new CodeObject[numTopLevelObjects.intValue()];
        for (int i = 0; i < numTopLevelObjects; ++i) {
            codeObjects[i] = children.get(i);
        }
        return codeObjects;
    }
}

