/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks;

import com.appland.appmap.output.v1.Event;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.reflect.apache.HttpResponse;
import com.appland.appmap.reflect.apache.HttpUriRequest;
import com.appland.appmap.transform.annotations.ArgumentArray;
import com.appland.appmap.transform.annotations.ExcludeReceiver;
import com.appland.appmap.transform.annotations.HookClass;
import com.appland.appmap.transform.annotations.MethodEvent;
import com.appland.appmap.transform.annotations.Unique;
import com.appland.shade.okhttp3.HttpUrl;

@Unique(value="http_client_request")
public class HttpClientRequest {
    private static final Recorder recorder = Recorder.getInstance();

    @ArgumentArray
    @ExcludeReceiver
    @HookClass(value="org.apache.http.client.HttpClient")
    public static void execute(Event event, Object[] args2) {
        HttpUriRequest req = new HttpUriRequest(args2[0]);
        HttpUrl url = HttpUrl.get(req.getURI());
        HttpUrl noQuery = url.newBuilder().query(null).build();
        event.setHttpClientRequest(req.getMethod(), noQuery.toString());
        event.setParameters(null);
        int size = url.querySize();
        for (int i = 0; i < size; ++i) {
            String name = url.queryParameterName(i);
            String value = url.queryParameterValue(i);
            event.addMessageParam(name != null ? name : "", value != null ? value : "");
        }
        recorder.add(event);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookClass(value="org.apache.http.client.HttpClient", methodEvent=MethodEvent.METHOD_RETURN)
    public static void execute(Event event, Object ret, Object[] args2) {
        HttpResponse res = new HttpResponse(ret);
        event.setHttpClientResponse(res.getStatusCode(), res.getContentType());
        event.setParameters(null);
        recorder.add(event);
    }
}

