/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks.remoterecording;

import com.appland.appmap.config.Properties;
import com.appland.appmap.output.v1.Event;
import com.appland.appmap.process.ExitEarly;
import com.appland.appmap.process.conditions.RecordCondition;
import com.appland.appmap.process.hooks.remoterecording.RemoteRecordingManager;
import com.appland.appmap.process.hooks.remoterecording.ServletRequest;
import com.appland.appmap.record.ActiveSessionException;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.record.Recording;
import com.appland.appmap.reflect.FilterChain;
import com.appland.appmap.reflect.HttpServletRequest;
import com.appland.appmap.reflect.HttpServletResponse;
import com.appland.appmap.transform.annotations.ArgumentArray;
import com.appland.appmap.transform.annotations.ContinueHooking;
import com.appland.appmap.transform.annotations.ExcludeReceiver;
import com.appland.appmap.transform.annotations.HookAnnotated;
import com.appland.appmap.transform.annotations.HookClass;
import com.appland.appmap.transform.annotations.HookCondition;
import com.appland.appmap.transform.annotations.MethodEvent;
import com.appland.appmap.util.Logger;
import com.appland.appmap.util.StringUtil;

public class ServletHooks {
    private static final boolean debug = Properties.DebugHttp;
    private static final Recorder recorder = Recorder.getInstance();
    private static final String JUNIT_NAME = "junit";
    private static final String TESTNG_NAME = "testng";
    private static final String TEST_RECORDER_TYPE = "tests";

    private static void service(Object[] args2) throws ExitEarly {
        if (args2.length != 2) {
            return;
        }
        HttpServletRequest req = new HttpServletRequest(args2[0]);
        HttpServletResponse res = new HttpServletResponse(args2[1]);
        if (RemoteRecordingManager.service(new ServletRequest(req, res))) {
            throw new ExitEarly();
        }
    }

    private static void skipFilterChain(Object[] args2) throws ExitEarly {
        if (args2.length != 3) {
            if (debug) {
                Logger.println("ToggleRecord.skipFilterChain - invalid arg length");
            }
            return;
        }
        HttpServletRequest req = new HttpServletRequest(args2[0]);
        if (!req.getRequestURI().endsWith("/_appmap/record")) {
            return;
        }
        if (debug) {
            Logger.println("ToggleRecord.skipFilterChain - skipping filter chain");
        }
        FilterChain chain = new FilterChain(args2[2]);
        chain.doFilter(args2[0], args2[1]);
        if (debug) {
            Logger.println("ToggleRecord.skipFilterChain - successfully skipped, exiting early");
        }
        throw new ExitEarly();
    }

    @ExcludeReceiver
    @ArgumentArray
    @HookClass(value="javax.servlet.http.HttpServlet")
    public static void service(Event event, Object[] args2) throws ExitEarly {
        ServletHooks.service(args2);
    }

    @ExcludeReceiver
    @ArgumentArray
    @HookClass(value="jakarta.servlet.http.HttpServlet", method="service")
    public static void serviceJakarta(Event event, Object[] args2) throws ExitEarly {
        ServletHooks.service(args2);
    }

    @ContinueHooking
    @ExcludeReceiver
    @ArgumentArray
    @HookClass(value="javax.servlet.Filter")
    public static void doFilter(Event event, Object[] args2) throws ExitEarly {
        ServletHooks.skipFilterChain(args2);
    }

    @ContinueHooking
    @ExcludeReceiver
    @ArgumentArray
    @HookClass(value="jakarta.servlet.Filter", method="doFilter")
    public static void doFilterJakarta(Event event, Object[] args2) throws ExitEarly {
        ServletHooks.skipFilterChain(args2);
    }

    private static void startRecording(Event event, String recorderName, String recorderType) {
        Logger.printf("Recording started for %s\n", StringUtil.canonicalName(event));
        try {
            Recorder.Metadata metadata = new Recorder.Metadata(recorderName, recorderType);
            String feature = StringUtil.identifierToSentence(event.methodId);
            String featureGroup = StringUtil.identifierToSentence(event.definedClass);
            metadata.scenarioName = String.format("%s %s", featureGroup, StringUtil.decapitalize(feature));
            metadata.recordedClassName = event.definedClass;
            metadata.recordedMethodName = event.methodId;
            metadata.sourceLocation = String.join((CharSequence)":", event.path, String.valueOf(event.lineNumber));
            recorder.start(metadata);
        }
        catch (ActiveSessionException e) {
            Logger.printf("%s\n", e.getMessage());
        }
    }

    private static void stopRecording(Event event) {
        ServletHooks.stopRecording(event, null, null);
    }

    private static void stopRecording(Event event, boolean succeeded) {
        ServletHooks.stopRecording(event, succeeded, null);
    }

    private static void stopRecording(Event event, Boolean succeeded, Throwable exception) {
        Logger.printf("Recording stopped for %s\n", StringUtil.canonicalName(event));
        String filePath = String.join((CharSequence)"_", event.definedClass, event.methodId).replaceAll("[^a-zA-Z0-9-_]", "_");
        filePath = filePath + ".appmap.json";
        if (succeeded != null) {
            ServletHooks.recorder.getMetadata().testSucceeded = succeeded;
        }
        if (exception != null) {
            ServletHooks.recorder.getMetadata().exception = exception;
        }
        Recording recording = recorder.stop();
        recording.moveTo(filePath);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.junit.Test")
    public static void junit(Event event, Object[] args2) {
        ServletHooks.startRecording(event, JUNIT_NAME, TEST_RECORDER_TYPE);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.junit.Test", methodEvent=MethodEvent.METHOD_RETURN)
    public static void junit(Event event, Object returnValue, Object[] args2) {
        ServletHooks.stopRecording(event, true);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.junit.Test", methodEvent=MethodEvent.METHOD_EXCEPTION)
    public static void junit(Event event, Exception exception, Object[] args2) {
        event.setException(exception);
        recorder.add(event);
        ServletHooks.stopRecording(event, false, exception);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.junit.jupiter.api.Test")
    public static void junitJupiter(Event event, Object[] args2) {
        ServletHooks.startRecording(event, JUNIT_NAME, TEST_RECORDER_TYPE);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.junit.jupiter.api.Test", methodEvent=MethodEvent.METHOD_RETURN)
    public static void junitJupiter(Event event, Object returnValue, Object[] args2) {
        ServletHooks.stopRecording(event, true);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.junit.jupiter.api.Test", methodEvent=MethodEvent.METHOD_EXCEPTION)
    public static void junitJupiter(Event event, Exception exception, Object[] args2) {
        event.setException(exception);
        recorder.add(event);
        ServletHooks.stopRecording(event, false, exception);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.testng.annotations.Test")
    public static void testng(Event event, Object[] args2) {
        ServletHooks.startRecording(event, TESTNG_NAME, TEST_RECORDER_TYPE);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.testng.annotations.Test", methodEvent=MethodEvent.METHOD_RETURN)
    public static void testng(Event event, Object returnValue, Object[] args2) {
        ServletHooks.stopRecording(event, true);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.testng.annotations.Test", methodEvent=MethodEvent.METHOD_EXCEPTION)
    public static void testng(Event event, Exception exception, Object[] args2) {
        event.setException(exception);
        recorder.add(event);
        ServletHooks.stopRecording(event, false, exception);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookCondition(value=RecordCondition.class)
    public static void record(Event event, Object[] args2) {
        ServletHooks.startRecording(event, "record_process", "process");
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookCondition(value=RecordCondition.class, methodEvent=MethodEvent.METHOD_RETURN)
    public static void record(Event event, Object returnValue, Object[] args2) {
        ServletHooks.stopRecording(event);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookCondition(value=RecordCondition.class, methodEvent=MethodEvent.METHOD_EXCEPTION)
    public static void record(Event event, Exception exception, Object[] args2) {
        event.setException(exception);
        recorder.add(event);
        ServletHooks.stopRecording(event, null, exception);
    }
}

