/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.config;

import com.appland.appmap.cli.CLI;
import com.appland.appmap.config.AppMapPackage;
import com.appland.appmap.util.FullyQualifiedName;
import com.appland.appmap.util.Logger;
import com.appland.shade.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.appland.shade.com.fasterxml.jackson.databind.ObjectMapper;
import com.appland.shade.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AppMapConfig {
    public File configFile;
    public String name;
    public AppMapPackage[] packages = new AppMapPackage[0];
    private static AppMapConfig singleton = new AppMapConfig();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static File findConfig(File configFile, boolean mustExist) throws FileNotFoundException {
        Path projectDirectory;
        if (configFile.exists()) {
            return configFile;
        }
        if (mustExist) {
            throw new FileNotFoundException(configFile.toString());
        }
        for (Path parent = projectDirectory = configFile.toPath().toAbsolutePath().getParent(); parent != null; parent = parent.getParent()) {
            Path c = parent.resolve("appmap.yml");
            if (!Files.exists(c, new LinkOption[0])) continue;
            return c.toFile();
        }
        try (FileWriter fw = new FileWriter(configFile);){
            Files.createDirectories(projectDirectory, new FileAttribute[0]);
            fw.write(AppMapConfig.getDefault(projectDirectory.toString()));
            File file = configFile;
            return file;
        }
        catch (IOException e) {
            Logger.error("Failed to create default config\n", new Object[0]);
            Logger.error(e);
            throw new FileNotFoundException(configFile.toString());
        }
    }

    public static AppMapConfig load(File configFile, boolean mustExist) {
        FileInputStream inputStream = null;
        try {
            configFile = AppMapConfig.findConfig(configFile, mustExist);
            Logger.println(String.format("using config file -> %s", configFile.getAbsolutePath()));
            inputStream = new FileInputStream(configFile);
        }
        catch (FileNotFoundException e) {
            String expectedConfig = configFile.getAbsolutePath();
            Logger.println(String.format("error: file not found -> %s", expectedConfig));
            Logger.error(String.format("error: file not found -> %s", expectedConfig), new Object[0]);
            return null;
        }
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        try {
            singleton = mapper.readValue((InputStream)inputStream, AppMapConfig.class);
        }
        catch (IOException e) {
            Logger.error("AppMap: encountered syntax error in appmap.yml " + e.getMessage(), new Object[0]);
            System.exit(1);
        }
        AppMapConfig.singleton.configFile = configFile;
        return singleton;
    }

    public static AppMapConfig get() {
        return singleton;
    }

    public AppMapPackage.LabelConfig includes(FullyQualifiedName canonicalName) {
        if (this.packages == null) {
            return null;
        }
        for (AppMapPackage pkg : this.packages) {
            AppMapPackage.LabelConfig ls = pkg.find(canonicalName);
            if (ls == null) continue;
            return ls;
        }
        return null;
    }

    public Boolean excludes(FullyQualifiedName canonicalName) {
        if (this.packages == null) {
            return false;
        }
        for (AppMapPackage pkg : this.packages) {
            if (!pkg.excludes(canonicalName).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isShallow(FullyQualifiedName canonicalName) {
        if (canonicalName == null) {
            return false;
        }
        for (AppMapPackage pkg : this.packages) {
            if (pkg.find(canonicalName) == null) continue;
            return pkg.shallow;
        }
        return false;
    }

    public static String getDefault(String directory) throws IOException {
        StringWriter sw = new StringWriter();
        final PrintWriter pw = new PrintWriter(sw);
        pw.println("# This is the AppMap configuration file.");
        pw.println("# For full documentation of this file for Java programs, see:");
        pw.println("# https://appland.com/docs/reference/appmap-java.html#configuration");
        pw.format("name: %s\n", CLI.projectName(new File(directory)));
        File javaDir = Paths.get(directory, new String[0]).resolve("src/main/java").toFile();
        if (javaDir.isDirectory()) {
            final int pkgStart = javaDir.toPath().getNameCount();
            final HashSet packages = new HashSet();
            Files.walkFileTree(javaDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (file.getFileName().toString().endsWith(".java")) {
                        int pkgEnd = file.getParent().getNameCount();
                        if (pkgStart == pkgEnd) {
                            return FileVisitResult.CONTINUE;
                        }
                        Path packagePath = file.getParent().subpath(pkgStart, pkgEnd);
                        if (packagePath.getNameCount() > 0) {
                            packages.add(packagePath);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            pw.print("\n# Your project contains the directory src/main/java. AppMap has\n# auto-detected the following Java packages in this directory:\npackages:\n");
            List topLevelPackages = packages.stream().sorted().collect(ArrayList::new, (memo, packagePath) -> {
                for (int i = 1; i < packagePath.getNameCount(); ++i) {
                    Path ancestorPath = packagePath.subpath(0, i);
                    if (!memo.contains(ancestorPath)) continue;
                    return;
                }
                memo.add(packagePath);
            }, ArrayList::addAll);
            topLevelPackages.forEach(new Consumer<Path>(){

                @Override
                public void accept(Path packagePath) {
                    ArrayList<String> tokens = new ArrayList<String>();
                    for (int i = 0; i < packagePath.getNameCount(); ++i) {
                        tokens.add(packagePath.getName(i).toString());
                    }
                    String path = String.join((CharSequence)".", tokens);
                    pw.format("- path: %s\n", path);
                }
            });
        } else {
            pw.println("packages: []");
            pw.println("# appmap-java init looks for source packages in src/main/java.");
            pw.println("# This folder was not found in your project, so no packages were auto-detected.");
            pw.println("# You can add your source packages by replacing the line above with lines like this:");
            pw.println("# packages:");
            pw.println("# - path: com.mycorp.pkg");
            pw.println("# - path: org.otherstuff.pkg");
        }
        return sw.toString();
    }
}

