/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks;

import com.appland.appmap.output.v1.Event;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.reflect.apache.HttpHost;
import com.appland.appmap.reflect.apache.HttpRequest;
import com.appland.appmap.reflect.apache.HttpResponse;
import com.appland.appmap.reflect.apache.HttpUriRequest;
import com.appland.appmap.transform.annotations.ArgumentArray;
import com.appland.appmap.transform.annotations.ExcludeReceiver;
import com.appland.appmap.transform.annotations.HookClass;
import com.appland.appmap.transform.annotations.MethodEvent;
import com.appland.appmap.transform.annotations.Signature;
import com.appland.appmap.transform.annotations.Signatures;
import com.appland.appmap.transform.annotations.Unique;
import com.appland.shade.org.springframework.web.util.UriComponents;
import com.appland.shade.org.springframework.web.util.UriComponentsBuilder;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Unique(value="http_client_request")
public class HttpClientRequest {
    private static final Recorder recorder = Recorder.getInstance();

    @ArgumentArray
    @ExcludeReceiver
    @HookClass(value="org.apache.http.client.HttpClient")
    @Signatures(value={@Signature(value={"org.apache.http.client.methods.HttpUriRequest"}), @Signature(value={"org.apache.http.client.methods.HttpUriRequest", "org.apache.http.protocol.HttpContext"})})
    public static void execute(Event event, Object[] args) {
        HttpUriRequest req = new HttpUriRequest(args[0]);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri(req.getURI());
        HttpClientRequest.execute(event, req.getMethod(), builder);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookClass(value="org.apache.http.client.HttpClient", method="execute")
    @Signatures(value={@Signature(value={"org.apache.http.HttpHost", "org.apache.http.HttpRequest"}), @Signature(value={"org.apache.http.HttpHost", "org.apache.http.HttpRequest", "org.apache.http.protocol.HttpContext"})})
    public static void executeOnHost(Event event, Object[] args) {
        HttpHost host = new HttpHost(args[0]);
        HttpRequest req = new HttpRequest(args[1]);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString(req.getUri());
        UriComponentsBuilder hostBuilder = UriComponentsBuilder.fromUriString(host.toURI());
        builder.uriComponents(hostBuilder.build());
        HttpClientRequest.execute(event, req.getMethod(), builder);
    }

    private static void execute(Event event, String method, UriComponentsBuilder builder) {
        UriComponents withQuery = builder.build(true);
        UriComponents noQuery = builder.replaceQuery(null).build(true);
        event.setHttpClientRequest(method, noQuery.toString());
        event.setParameters(null);
        Set entrySet = withQuery.getQueryParams().entrySet();
        for (Map.Entry param : entrySet) {
            List allValues = (List)param.getValue();
            String[] values = allValues.toArray(new String[0]);
            event.addMessageParam((String)param.getKey(), values.length > 0 ? values[0] : "");
        }
        recorder.add(event);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookClass(value="org.apache.http.client.HttpClient", methodEvent=MethodEvent.METHOD_RETURN)
    @Signatures(value={@Signature(value={"org.apache.http.client.methods.HttpUriRequest"}), @Signature(value={"org.apache.http.client.methods.HttpUriRequest", "org.apache.http.protocol.HttpContext"}), @Signature(value={"org.apache.http.HttpHost", "org.apache.http.HttpRequest"}), @Signature(value={"org.apache.http.HttpHost", "org.apache.http.HttpRequest", "org.apache.http.protocol.HttpContext"})})
    public static void execute(Event event, Object ret, Object[] args) {
        HttpResponse res = new HttpResponse(ret);
        event.setHttpClientResponse(res.getStatusCode(), res.getContentType());
        event.setParameters(null);
        recorder.add(event);
    }
}

