/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform.annotations;

import com.appland.appmap.config.Properties;
import com.appland.appmap.util.Logger;
import com.appland.shade.javassist.ClassPool;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.javassist.NotFoundException;

class CtClassUtil {
    CtClassUtil() {
    }

    public static Boolean isChildOf(CtClass candidateChildClass, String parentClassName) {
        if (candidateChildClass.getName().equals(parentClassName)) {
            return true;
        }
        CtClass[] interfaces = CtClassUtil.tryClass(candidateChildClass, "interfaces", candidateChildClass::getInterfaces);
        if (interfaces != null) {
            for (CtClass superType : interfaces) {
                if (superType.getName().equals(parentClassName)) {
                    return true;
                }
                if (!CtClassUtil.isChildOf(superType, parentClassName).booleanValue()) continue;
                return true;
            }
        }
        CtClass superClass = CtClassUtil.tryClass(candidateChildClass, "superclass", candidateChildClass::getSuperclass);
        while (superClass != null) {
            if (superClass.getName().equals(parentClassName)) {
                return true;
            }
            CtClass cls = superClass;
            superClass = CtClassUtil.tryClass(cls, "superclass", cls::getSuperclass);
        }
        return false;
    }

    private static <V> V tryClass(CtClass cls, String member, ClassAccessor<V> accessor) {
        try {
            return accessor.navigate();
        }
        catch (NotFoundException e) {
            if (Properties.DebugHooks.booleanValue()) {
                Logger.printf("NotFoundException resolving %s of class %s: %s\n", member, cls.getName(), e.getMessage());
            }
            return null;
        }
    }

    public static Boolean isChildOf(String childClassName, CtClass parentClass) {
        ClassPool cp = ClassPool.getDefault();
        try {
            CtClass childClass = cp.get(childClassName);
            return CtClassUtil.isChildOf(childClass, parentClass.getName());
        }
        catch (NotFoundException e) {
            Logger.println(e);
            return false;
        }
    }

    static interface ClassAccessor<V> {
        public V navigate() throws NotFoundException;
    }
}

