/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.springframework.core.io;

import com.appland.shade.org.springframework.core.io.InputStreamSource;
import com.appland.shade.org.springframework.lang.Nullable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public interface Resource
extends InputStreamSource {
    public boolean exists();

    default public boolean isReadable() {
        return this.exists();
    }

    default public boolean isOpen() {
        return false;
    }

    default public boolean isFile() {
        return false;
    }

    public URL getURL() throws IOException;

    public URI getURI() throws IOException;

    public File getFile() throws IOException;

    default public ReadableByteChannel readableChannel() throws IOException {
        return Channels.newChannel(this.getInputStream());
    }

    public long contentLength() throws IOException;

    public long lastModified() throws IOException;

    public Resource createRelative(String var1) throws IOException;

    @Nullable
    public String getFilename();

    public String getDescription();
}

