/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.config;

import com.appland.appmap.util.Logger;
import java.io.File;
import java.util.function.Function;

public class Properties {
    public static final Boolean Debug = System.getProperty("appmap.debug") != null;
    public static final Boolean DebugHooks = Debug != false || System.getProperty("appmap.debug.hooks") != null;
    public static final Boolean DebugLocals = System.getProperty("appmap.debug.locals") != null;
    public static final Boolean DebugHttp = Debug != false || System.getProperty("appmap.debug.http") != null;
    public static final String DebugFile = Properties.resolveProperty("appmap.debug.file", (String)null);
    public static final Boolean RecordingAuto = Properties.resolveProperty("appmap.recording.auto", Boolean::valueOf, false);
    public static final String RecordingName = Properties.resolveProperty("appmap.recording.name", (String)null);
    public static final String RecordingFile = Properties.resolveProperty("appmap.recording.file", (String)null);
    public static final String DefaultOutputDirectory = "./tmp/appmap";
    public static final String OutputDirectory = Properties.resolveProperty("appmap.output.directory", "./tmp/appmap");
    public static final String DefaultConfigFile = "appmap.yml";
    public static final String ConfigFile = Properties.resolveProperty("appmap.config.file", (String)null);
    public static final Integer DefaultMaxValueSize = 1024;
    public static final Integer MaxValueSize = Properties.resolveProperty("appmap.event.valueSize", Integer::valueOf, DefaultMaxValueSize);
    public static final String[] DefaultRecords = new String[0];
    public static final String[] Records = Properties.resolveProperty("appmap.record", DefaultRecords);
    public static final Boolean RecordPrivate = Properties.resolveProperty("appmap.record.private", Boolean::valueOf, false);
    public static final Boolean RecordRequests = Properties.resolveProperty("appmap.record.requests", Boolean::valueOf, true);

    private static String resolveProperty(String propName, String defaultValue) {
        String value = defaultValue;
        try {
            String propValue = System.getProperty(propName);
            if (propValue != null) {
                value = propValue;
            }
        }
        catch (Exception e) {
            Logger.printf("failed to resolve %s, falling back to default\n", propName);
            Logger.println(e);
        }
        return value;
    }

    public static File getOutputDirectory() {
        File dir = new File(OutputDirectory);
        if (!dir.exists() && !dir.mkdirs()) {
            Logger.println("failed to create directories: " + OutputDirectory);
        }
        return dir;
    }

    private static <T> T resolveProperty(String propName, Function<String, T> resolvingFunc, T defaultValue) {
        T value = defaultValue;
        try {
            String propValue = System.getProperty(propName);
            if (propValue != null) {
                value = resolvingFunc.apply(propValue);
            }
        }
        catch (Exception e) {
            Logger.printf("failed to resolve %s, falling back to default\n", propName);
            Logger.println(e);
            value = defaultValue;
        }
        return value;
    }

    private static String[] resolveProperty(String propName, String[] defaultValue) {
        String[] value = defaultValue;
        try {
            String propValue = System.getProperty(propName);
            if (propValue != null) {
                value = propValue.split(",");
                assert (value.length < 2);
            }
        }
        catch (Exception e) {
            System.err.printf("failed to resolve %s, falling back to default\n", propName);
            e.printStackTrace(System.err);
        }
        return value;
    }

    public static String[] getRecords() {
        return Records;
    }
}

