/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.reflect;

import com.appland.appmap.config.AppMapConfig;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ReflectiveType {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);
    private Map<String, Method> methods = new HashMap<String, Method>();
    protected Object self;

    public ReflectiveType(Object self) {
        this.self = self;
        this.addMethods("hashCode", "toString");
        this.addMethod("equals", Object.class);
    }

    public int hashCode() {
        return this.invokeIntMethod("hashCode", new Object[0]);
    }

    public String toString() {
        return this.invokeStringMethod("toString", new Object[0]);
    }

    public boolean equals(Object other) {
        return this.invokeMethod("equals", Boolean.FALSE, other);
    }

    protected void addMethods(String ... names) {
        for (String name : names) {
            this.methods.put(name, this.getMethod(name, new Class[0]));
        }
    }

    protected void addMethod(String name, Class<?> ... parameterTypes) {
        this.methods.put(name, this.getMethod(name, parameterTypes));
    }

    protected Method getMethod(String name, Class<?> ... parameterTypes) {
        Class<?> cls = this.self.getClass();
        try {
            return cls.getMethod(name, parameterTypes);
        }
        catch (Exception e) {
            logger.warn((Throwable)e, "failed to get method {}.{}", cls.getName(), name);
            return null;
        }
    }

    protected void addMethod(String name, String ... parameterTypes) {
        this.methods.put(name, this.getMethodByClassNames(name, parameterTypes));
    }

    protected Object invokeWrappedMethod(Method method, Object ... parameters) {
        try {
            method.setAccessible(true);
            logger.trace("method: {} parameters: {}", method, parameters);
            return method.invoke(this.self, parameters);
        }
        catch (InvocationTargetException e) {
            logger.warn((Throwable)e, "{}.{} threw an exception", this.self.getClass().getName(), method.getName());
            throw new Error(e);
        }
        catch (Exception e) {
            logger.warn((Throwable)e, "failed invoking {}.{}", this.self.getClass().getName(), method.getName());
            if (e.getCause() != null) {
                logger.warn(e.getCause());
            }
            return null;
        }
    }

    protected <T> T invokeMethod(String name, T defaultValue, Object ... parameters) {
        Method m = this.methods.get(name);
        return (T)(m != null ? this.invokeWrappedMethod(m, parameters) : defaultValue);
    }

    protected String invokeStringMethod(String name, Object ... parameters) {
        return this.invokeMethod(name, "", parameters);
    }

    protected Integer invokeIntMethod(String name, Object ... parameters) {
        return this.invokeMethod(name, -1, parameters);
    }

    protected Object invokeObjectMethod(String name, Object ... parameters) {
        return this.invokeMethod(name, null, parameters);
    }

    protected void invokeVoidMethod(String name, Object ... parameters) {
        this.invokeMethod(name, null, parameters);
    }

    protected Method getMethodByClassNames(String name, String ... parameterTypes) {
        Method[] methods;
        logger.trace("self.getClass(): {}", this.self.getClass());
        try {
            methods = this.self.getClass().getMethods();
        }
        catch (Exception e) {
            logger.warn((Throwable)e, "failed to get methods for {}", this.self.getClass().getName());
            return null;
        }
        for (Method method : methods) {
            logger.trace("method: {}", method.getName());
            if (!method.getName().equals(name)) continue;
            Class<?>[] methodParamTypes = method.getParameterTypes();
            if (methodParamTypes.length != parameterTypes.length) {
                logger.trace("parameter type lengths don't match");
                continue;
            }
            boolean match = true;
            for (int i = 0; i < methodParamTypes.length; ++i) {
                String actual = methodParamTypes[i].getName();
                String expected = parameterTypes[i];
                logger.trace("actual: \"{}\" expected: \"{}\"", actual, expected);
                if (actual.equals(expected)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return method;
        }
        logger.warn("No match for method {}", name);
        return null;
    }
}

