/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.config.Properties;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.record.Recording;
import com.appland.appmap.transform.ClassFileTransformer;
import com.appland.shade.javassist.ClassPool;
import com.appland.shade.org.tinylog.TaggedLogger;
import com.appland.shade.org.tinylog.provider.ProviderRegistry;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Agent {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);

    public static void premain(String agentArgs, Instrumentation inst) {
        String configFile;
        logger.debug("Agent version {}", Agent.class.getPackage().getImplementationVersion());
        logger.debug("System properties: {}", System.getProperties());
        logger.debug((Throwable)new Exception(), "whereAmI");
        logger.trace("Agent.class class loader: {}", Agent.class.getClassLoader());
        logger.trace("ClassPool.getDefault(): {}", ClassPool.getDefault());
        inst.addTransformer(new ClassFileTransformer());
        boolean configSpecified = Properties.ConfigFile != null;
        String string = configFile = !configSpecified ? "appmap.yml" : Properties.ConfigFile;
        if (AppMapConfig.load(new File(configFile), configSpecified) == null) {
            logger.error("failed to load config {}", Properties.ConfigFile);
            System.exit(1);
        }
        Runnable logShutdown = () -> {
            try {
                ProviderRegistry.getLoggingProvider().shutdown();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        };
        if (Properties.RecordingAuto.booleanValue()) {
            String appmapName = Properties.RecordingName;
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmss");
            String timestamp = dateFormat.format(date);
            Recorder.Metadata metadata = new Recorder.Metadata("java", "process");
            Recorder recorder = Recorder.getInstance();
            if (appmapName == null || appmapName.trim().isEmpty()) {
                appmapName = timestamp;
            }
            metadata.scenarioName = appmapName;
            recorder.start(metadata);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                String fileName = Properties.RecordingFile;
                if (fileName == null || fileName.trim().isEmpty()) {
                    fileName = String.format("%s.appmap.json", timestamp);
                }
                Recording recording = recorder.stop();
                recording.moveTo(fileName);
                logShutdown.run();
            }));
        } else {
            Runtime.getRuntime().addShutdownHook(new Thread(logShutdown));
        }
    }
}

