/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.cli;

import com.appland.appmap.cli.CLI;
import com.appland.appmap.config.AppMapConfig;
import com.appland.shade.com.alibaba.fastjson.JSON;
import com.appland.shade.com.alibaba.fastjson.annotation.JSONField;
import com.appland.shade.com.alibaba.fastjson.serializer.SerializerFeature;
import com.appland.shade.picocli.CommandLine;
import java.util.concurrent.Callable;

@CommandLine.Command(name="init", description={"Suggests AppMap configuration settings for a new project."})
public class Init
implements Callable<Integer> {
    @CommandLine.ParentCommand
    private CLI parent;

    @Override
    public Integer call() throws Exception {
        System.err.printf("Init AppMap project configuration in directory: %s\n", this.parent.directory);
        String contents = AppMapConfig.getDefault(this.parent.directory);
        Configuration configuration = new Configuration();
        configuration.filename = "appmap.yml";
        configuration.contents = contents;
        Result result = new Result();
        result.configuration = configuration;
        this.parent.getOutputStream().println(JSON.toJSONString((Object)result, SerializerFeature.PrettyFormat));
        return 0;
    }

    static class Result {
        @JSONField
        public Configuration configuration;

        Result() {
        }
    }

    static class Configuration {
        @JSONField
        public String filename;
        @JSONField
        public String contents;

        Configuration() {
        }
    }
}

