/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.record;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.config.Properties;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.function.Function;

public class Recording {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);
    private final Path outputDirectory;
    private final File file;
    public static final DateTimeFormatter RECORDING_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");

    public Recording(String recorderName, File file) {
        this.outputDirectory = Paths.get(Properties.getOutputDirectory().toString(), recorderName);
        this.file = file;
    }

    public void delete() {
        this.file.delete();
    }

    public Path moveTo(String filePath) {
        return this.moveTo(this.outputDirectory.resolve(filePath));
    }

    public Path moveTo(Path targetPath) {
        Path sourcePath = Paths.get(this.file.getPath(), new String[0]);
        logger.debug("Moving {} to {}", sourcePath, targetPath);
        Function<FileMover, FileMover.Result> tryMove = mover -> {
            IOException exception = null;
            try {
                mover.move();
            }
            catch (IOException e) {
                exception = e;
            }
            return new FileMover.Result(exception);
        };
        FileMover[] movers = new FileMover[]{() -> Files.move(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE), () -> Files.move(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING), () -> {
            Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            sourcePath.toFile().delete();
        }};
        ArrayList<String> errors = new ArrayList<String>();
        Throwable lastException = null;
        try {
            Files.createDirectories(this.outputDirectory, new FileAttribute[0]);
            for (FileMover mover2 : movers) {
                FileMover.Result r = tryMove.apply(mover2);
                if (r.isSucceeded()) {
                    errors.clear();
                    break;
                }
                lastException = r.exception;
                errors.add(r.exception.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            errors.add(e.toString());
        }
        if (!errors.isEmpty()) {
            if (lastException != null) {
                lastException.printStackTrace();
            }
            throw new RuntimeException(String.join((CharSequence)", ", errors));
        }
        return targetPath;
    }

    public void readFully(boolean delete, Writer writer) throws IOException {
        try (FileReader reader = new FileReader(this.file);){
            int bytesRead;
            char[] buffer = new char[2048];
            while ((bytesRead = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, bytesRead);
            }
            writer.flush();
            if (delete) {
                this.delete();
            }
        }
    }

    public int size() {
        return (int)this.file.length();
    }

    public InputStream asInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    static interface FileMover {
        public void move() throws IOException;

        public static class Result {
            final IOException exception;

            Result(IOException exception) {
                this.exception = exception;
            }

            boolean isSucceeded() {
                return this.exception == null;
            }
        }
    }
}

