/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform.annotations;

import com.appland.appmap.config.AppMapConfig;
import com.appland.shade.javassist.ClassPool;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.javassist.NotFoundException;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.util.Arrays;
import java.util.stream.Collectors;

class CtClassUtil {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);

    CtClassUtil() {
    }

    public static Boolean isChildOf(CtClass candidateChildClass, CtClass parentClass) {
        String parentClassName;
        String childClassName = candidateChildClass.getName();
        if (childClassName.equals(parentClassName = parentClass.getName())) {
            return true;
        }
        CtClass[] interfaces = CtClassUtil.tryClass(candidateChildClass, "interfaces", candidateChildClass::getInterfaces);
        logger.trace("interfaces: {}", () -> Arrays.asList(interfaces).stream().map(c -> c.getName()).collect(Collectors.joining(",")));
        if (interfaces != null && interfaces.length > 0) {
            for (CtClass superType : interfaces) {
                logger.trace(() -> String.format("interface: %s", superType.getName()));
                if (superType.getName().equals(parentClassName)) {
                    return true;
                }
                if (!CtClassUtil.isChildOf(superType, parentClass).booleanValue()) continue;
                return true;
            }
        }
        CtClass superClass = CtClassUtil.tryClass(candidateChildClass, "superclass", candidateChildClass::getSuperclass);
        logger.trace("superClass: {}", () -> superClass != null ? superClass.getName() : "null");
        if (superClass == null) {
            return false;
        }
        if (superClass.getName().equals("java.lang.Object")) {
            return parentClassName.equals("java.lang.Object");
        }
        return CtClassUtil.isChildOf(superClass, parentClass);
    }

    private static <V> V tryClass(CtClass cls, String member, ClassAccessor<V> accessor) {
        try {
            return accessor.navigate();
        }
        catch (NotFoundException e) {
            logger.trace((Throwable)e, () -> String.format("Resolving %s of class %s", member, cls.getName()));
            return null;
        }
    }

    public static Boolean isChildOf(String childClassName, CtClass parentClass) {
        String parentClassName = parentClass.getName();
        boolean namesEqual = childClassName.equals(parentClassName);
        if (namesEqual) {
            return true;
        }
        ClassPool cp = ClassPool.getDefault();
        try {
            CtClass childClass = cp.get(childClassName);
            Boolean ret = CtClassUtil.isChildOf(childClass, parentClass);
            logger.debug(() -> String.format("childClassName: %s, parentClassName: %s ret: %s", childClassName, parentClass.getName(), ret));
            return ret;
        }
        catch (NotFoundException e) {
            logger.trace(e);
            return false;
        }
    }

    public static Boolean isChildOf(CtClass childClass, String parentClassName) {
        String childClassName = childClass.getName();
        boolean namesEqual = childClassName.equals(parentClassName);
        if (namesEqual) {
            return true;
        }
        ClassPool cp = ClassPool.getDefault();
        try {
            CtClass parentClass = cp.get(parentClassName);
            Boolean ret = CtClassUtil.isChildOf(childClass, parentClass);
            logger.debug(() -> String.format("childClassName: %s, parentClassName: %s ret: %s", childClass.getName(), parentClassName, ret));
            return ret;
        }
        catch (NotFoundException e) {
            logger.trace(e);
            return false;
        }
    }

    public static Boolean isChildOf(String childClassName, String parentClassName) {
        boolean namesEqual = childClassName.equals(parentClassName);
        if (namesEqual) {
            return true;
        }
        ClassPool cp = ClassPool.getDefault();
        try {
            CtClass parentClass = cp.get(parentClassName);
            Boolean ret = CtClassUtil.isChildOf(childClassName, parentClass);
            logger.debug(() -> String.format("childClassName: %s, parentClassName: %s ret: %s", childClassName, parentClassName, ret));
            return ret;
        }
        catch (NotFoundException e) {
            logger.trace(e);
            return false;
        }
    }

    public static void main(String[] argv) {
        String child = argv[0];
        String parent = argv[1];
        logger.info("{} {}", child, parent);
        System.out.println(String.format("isChildOf(%s, %s): %b", child, parent, CtClassUtil.isChildOf(child, parent)));
    }

    static interface ClassAccessor<V> {
        public V navigate() throws NotFoundException;
    }
}

