/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.reflections.util;

import com.appland.shade.com.google.common.base.Predicate;
import com.appland.shade.com.google.common.collect.Lists;
import com.appland.shade.com.google.common.collect.ObjectArrays;
import com.appland.shade.com.google.common.collect.Sets;
import com.appland.shade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.appland.shade.org.reflections.Configuration;
import com.appland.shade.org.reflections.Reflections;
import com.appland.shade.org.reflections.ReflectionsException;
import com.appland.shade.org.reflections.adapters.JavaReflectionAdapter;
import com.appland.shade.org.reflections.adapters.JavassistAdapter;
import com.appland.shade.org.reflections.adapters.MetadataAdapter;
import com.appland.shade.org.reflections.scanners.Scanner;
import com.appland.shade.org.reflections.scanners.SubTypesScanner;
import com.appland.shade.org.reflections.scanners.TypeAnnotationsScanner;
import com.appland.shade.org.reflections.serializers.Serializer;
import com.appland.shade.org.reflections.serializers.XmlSerializer;
import com.appland.shade.org.reflections.util.ClasspathHelper;
import com.appland.shade.org.reflections.util.FilterBuilder;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConfigurationBuilder
implements Configuration {
    @Nonnull
    private Set<Scanner> scanners = Sets.newHashSet(new TypeAnnotationsScanner(), new SubTypesScanner());
    @Nonnull
    private Set<URL> urls = Sets.newHashSet();
    protected MetadataAdapter metadataAdapter;
    @Nullable
    private Predicate<String> inputsFilter;
    private Serializer serializer;
    @Nullable
    private ExecutorService executorService;
    @Nullable
    private ClassLoader[] classLoaders;
    private boolean expandSuperTypes = true;

    /*
     * WARNING - void declaration
     */
    public static ConfigurationBuilder build(Object ... params) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ArrayList<Object> parameters = Lists.newArrayList();
        if (params != null) {
            void var5_7;
            Object[] arr$ = params;
            int len$ = arr$.length;
            boolean bl = false;
            while (var5_7 < len$) {
                Object param = arr$[var5_7];
                if (param != null) {
                    if (param.getClass().isArray()) {
                        for (Object p : (Object[])param) {
                            if (p == null) continue;
                            parameters.add(p);
                        }
                    } else if (param instanceof Iterable) {
                        for (Object p : (Iterable)param) {
                            if (p == null) continue;
                            parameters.add(p);
                        }
                    } else {
                        parameters.add(param);
                    }
                }
                ++var5_7;
            }
        }
        ArrayList<ClassLoader> loaders = Lists.newArrayList();
        for (Object e : parameters) {
            if (!(e instanceof ClassLoader)) continue;
            loaders.add((ClassLoader)e);
        }
        ClassLoader[] classLoaders = loaders.isEmpty() ? null : loaders.toArray(new ClassLoader[loaders.size()]);
        FilterBuilder filterBuilder = new FilterBuilder();
        ArrayList<Scanner> scanners = Lists.newArrayList();
        for (Object param : parameters) {
            if (param instanceof String) {
                builder.addUrls(ClasspathHelper.forPackage((String)param, classLoaders));
                filterBuilder.includePackage((String)param);
                continue;
            }
            if (param instanceof Class) {
                if (Scanner.class.isAssignableFrom((Class)param)) {
                    try {
                        builder.addScanners((Scanner)((Class)param).newInstance());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                builder.addUrls(ClasspathHelper.forClass((Class)param, classLoaders));
                filterBuilder.includePackage((Class)param);
                continue;
            }
            if (param instanceof Scanner) {
                scanners.add((Scanner)param);
                continue;
            }
            if (param instanceof URL) {
                builder.addUrls((URL)param);
                continue;
            }
            if (param instanceof ClassLoader) continue;
            if (param instanceof Predicate) {
                filterBuilder.add((Predicate)param);
                continue;
            }
            if (param instanceof ExecutorService) {
                builder.setExecutorService((ExecutorService)param);
                continue;
            }
            if (Reflections.log == null) continue;
            throw new ReflectionsException("could not use param " + param);
        }
        if (builder.getUrls().isEmpty()) {
            if (classLoaders != null) {
                builder.addUrls(ClasspathHelper.forClassLoader(classLoaders));
            } else {
                builder.addUrls(ClasspathHelper.forClassLoader());
            }
        }
        builder.filterInputsBy(filterBuilder);
        if (!scanners.isEmpty()) {
            builder.setScanners(scanners.toArray(new Scanner[scanners.size()]));
        }
        if (!loaders.isEmpty()) {
            builder.addClassLoaders(loaders);
        }
        return builder;
    }

    public ConfigurationBuilder forPackages(String ... packages) {
        for (String pkg : packages) {
            this.addUrls(ClasspathHelper.forPackage(pkg, new ClassLoader[0]));
        }
        return this;
    }

    @Override
    @Nonnull
    public Set<Scanner> getScanners() {
        return this.scanners;
    }

    public ConfigurationBuilder setScanners(Scanner ... scanners) {
        this.scanners.clear();
        return this.addScanners(scanners);
    }

    public ConfigurationBuilder addScanners(Scanner ... scanners) {
        this.scanners.addAll(Sets.newHashSet(scanners));
        return this;
    }

    @Override
    @Nonnull
    public Set<URL> getUrls() {
        return this.urls;
    }

    public ConfigurationBuilder setUrls(@Nonnull Collection<URL> urls) {
        this.urls = Sets.newHashSet(urls);
        return this;
    }

    public ConfigurationBuilder setUrls(URL ... urls) {
        this.urls = Sets.newHashSet(urls);
        return this;
    }

    public ConfigurationBuilder addUrls(Collection<URL> urls) {
        this.urls.addAll(urls);
        return this;
    }

    public ConfigurationBuilder addUrls(URL ... urls) {
        this.urls.addAll(Sets.newHashSet(urls));
        return this;
    }

    @Override
    public MetadataAdapter getMetadataAdapter() {
        if (this.metadataAdapter != null) {
            return this.metadataAdapter;
        }
        try {
            this.metadataAdapter = new JavassistAdapter();
            return this.metadataAdapter;
        }
        catch (Throwable e) {
            if (Reflections.log != null) {
                Reflections.log.warn("could not create JavassistAdapter, using JavaReflectionAdapter", e);
            }
            this.metadataAdapter = new JavaReflectionAdapter();
            return this.metadataAdapter;
        }
    }

    public ConfigurationBuilder setMetadataAdapter(MetadataAdapter metadataAdapter) {
        this.metadataAdapter = metadataAdapter;
        return this;
    }

    @Override
    @Nullable
    public Predicate<String> getInputsFilter() {
        return this.inputsFilter;
    }

    public void setInputsFilter(@Nullable Predicate<String> inputsFilter) {
        this.inputsFilter = inputsFilter;
    }

    public ConfigurationBuilder filterInputsBy(Predicate<String> inputsFilter) {
        this.inputsFilter = inputsFilter;
        return this;
    }

    @Override
    @Nullable
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public ConfigurationBuilder setExecutorService(@Nullable ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public ConfigurationBuilder useParallelExecutor() {
        return this.useParallelExecutor(Runtime.getRuntime().availableProcessors());
    }

    public ConfigurationBuilder useParallelExecutor(int availableProcessors) {
        ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("com.appland.shade.org.reflections-scanner-%d").build();
        this.setExecutorService(Executors.newFixedThreadPool(availableProcessors, factory));
        return this;
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer != null ? this.serializer : (this.serializer = new XmlSerializer());
    }

    public ConfigurationBuilder setSerializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    @Override
    @Nullable
    public ClassLoader[] getClassLoaders() {
        return this.classLoaders;
    }

    @Override
    public boolean shouldExpandSuperTypes() {
        return this.expandSuperTypes;
    }

    public ConfigurationBuilder setExpandSuperTypes(boolean expandSuperTypes) {
        this.expandSuperTypes = expandSuperTypes;
        return this;
    }

    public void setClassLoaders(@Nullable ClassLoader[] classLoaders) {
        this.classLoaders = classLoaders;
    }

    public ConfigurationBuilder addClassLoader(ClassLoader classLoader) {
        return this.addClassLoaders(classLoader);
    }

    public ConfigurationBuilder addClassLoaders(ClassLoader ... classLoaders) {
        this.classLoaders = this.classLoaders == null ? classLoaders : ObjectArrays.concat(this.classLoaders, classLoaders, ClassLoader.class);
        return this;
    }

    public ConfigurationBuilder addClassLoaders(Collection<ClassLoader> classLoaders) {
        return this.addClassLoaders(classLoaders.toArray(new ClassLoader[classLoaders.size()]));
    }
}

