/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.tinylog.pattern;

import com.appland.shade.org.tinylog.core.LogEntry;
import com.appland.shade.org.tinylog.core.LogEntryValue;
import com.appland.shade.org.tinylog.pattern.Token;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;

class MinimumSizeToken
implements Token {
    private final Token token;
    private final int minimumSize;

    MinimumSizeToken(Token token, int size) {
        this.token = token;
        this.minimumSize = size;
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return this.token.getRequiredLogEntryValues();
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        int offset = builder.length();
        this.token.render(logEntry, builder);
        int size = builder.length() - offset;
        for (int i = 0; i < this.minimumSize - size; ++i) {
            builder.append(' ');
        }
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        StringBuilder builder = new StringBuilder();
        this.render(logEntry, builder);
        statement.setString(index, builder.toString());
    }
}

