/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.config.Properties;
import com.appland.appmap.output.v1.Event;
import com.appland.appmap.process.hooks.http.ServletContext;
import com.appland.appmap.process.hooks.http.ServletListener;
import com.appland.appmap.process.hooks.remoterecording.RemoteRecordingFilter;
import com.appland.appmap.reflect.ReflectiveType;
import com.appland.appmap.transform.annotations.ArgumentArray;
import com.appland.appmap.transform.annotations.ExcludeReceiver;
import com.appland.appmap.transform.annotations.HookClass;
import com.appland.appmap.transform.annotations.MethodEvent;
import com.appland.appmap.util.ClassUtil;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.util.EnumSet;

public class SpringBoot {
    private static final String SERVLET_CONTEXT_INITIALIZED = "com.appland.appmap.ServletContextInitialized";
    private static final String LISTENER_BEAN = "appmap.listener";
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);

    @ArgumentArray
    @HookClass(value="org.springframework.boot.SpringApplication", methodEvent=MethodEvent.METHOD_RETURN)
    public static void applyInitializers(Event event, Object receiver, Object ret, Object[] args) {
        Object initializedAttr;
        ApplicationContext appCtx = new ApplicationContext(args[0]);
        logger.trace((Throwable)new Exception(), "ctx: {}", appCtx);
        ServletContext servletCtx = appCtx.getServletContext();
        if (servletCtx != null && (initializedAttr = servletCtx.getAttribute(SERVLET_CONTEXT_INITIALIZED)) != null && ((Boolean)initializedAttr).booleanValue()) {
            logger.trace("servlet context initialized");
            return;
        }
        ConfigurableListableBeanFactory beanFactory = appCtx.getBeanFactory();
        if (beanFactory.getSingleton(LISTENER_BEAN) == null) {
            Object remoteRecordingFilter = RemoteRecordingFilter.build();
            Object servletListener = ServletListener.build();
            if (remoteRecordingFilter != null && servletListener != null) {
                beanFactory.registerSingleton("appmap.listener.remoteRecordingFilter", remoteRecordingFilter);
                if (Properties.RecordingRequests.booleanValue()) {
                    logger.trace("registering servlet listener as singleton");
                    beanFactory.registerSingleton(LISTENER_BEAN, servletListener);
                }
                logger.trace("registered beans");
            } else {
                logger.trace("a bean is null, remoteRecordingFilter: {} servletListener: {}", remoteRecordingFilter, servletListener);
            }
            logger.trace("initialized context");
        } else {
            logger.trace("already initialized");
        }
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookClass(value="org.springframework.web.SpringServletContainerInitializer")
    public static void onStartup(Event event, Object[] args) {
        ServletContext ctx = new ServletContext(args[1]);
        logger.trace((Throwable)new Exception(), "ctx: {}", ctx);
        if (Properties.RecordingRequests.booleanValue()) {
            logger.trace("adding listener to sevlet context");
            ctx.addListener(ServletListener.build());
        } else {
            logger.debug("request recording disabled");
        }
        ServletContext.FilterRegistration fr = ctx.addFilter("com.appland.appmap.RemoteRecordingFilter", RemoteRecordingFilter.build());
        fr.addMappingForUrlPatterns(SpringBoot.requestEnumSet(), true, "/_appmap/record");
        ctx.setAttribute(SERVLET_CONTEXT_INITIALIZED, Boolean.TRUE);
    }

    private static EnumSet<?> requestEnumSet() {
        Class<?> dispatcherType = ClassUtil.safeClassForName("javax.servlet.DispatcherType");
        if (dispatcherType == null && (dispatcherType = ClassUtil.safeClassForName("jakarta.servlet.DispatcherType")) == null) {
            throw new InternalError("no DispatcherType class");
        }
        return SpringBoot.requestEnumSet(dispatcherType.asSubclass(Enum.class));
    }

    private static <E extends Enum<E>> EnumSet<E> requestEnumSet(Class<E> enumClass) {
        try {
            E requestValue = Enum.valueOf(enumClass, "REQUEST");
            return EnumSet.of(requestValue);
        }
        catch (IllegalArgumentException e) {
            throw new InternalError("failed to fetch DispatcherType.REQUEST", e);
        }
    }

    static class ConfigurableListableBeanFactory
    extends ReflectiveType {
        private static final String GET_SINGLETON = "getSingleton";
        private static final String REGISTER_SINGLETON = "registerSingleton";

        ConfigurableListableBeanFactory(Object self) {
            super(self);
            this.addMethod(GET_SINGLETON, String.class);
            this.addMethod(REGISTER_SINGLETON, String.class, Object.class);
        }

        public Object getSingleton(String name) {
            return this.invokeObjectMethod(GET_SINGLETON, name);
        }

        public void registerSingleton(String name, Object bean) {
            this.invokeVoidMethod(REGISTER_SINGLETON, name, bean);
        }
    }

    static class ApplicationContext
    extends ReflectiveType {
        private static String GET_BEAN_FACTORY = "getBeanFactory";
        private static String GET_SERVLET_CONTEXT = "getServletContext";

        ApplicationContext(Object self) {
            super(self);
            this.addMethods(GET_BEAN_FACTORY, GET_SERVLET_CONTEXT);
        }

        public ConfigurableListableBeanFactory getBeanFactory() {
            return new ConfigurableListableBeanFactory(this.invokeObjectMethod(GET_BEAN_FACTORY, new Object[0]));
        }

        public ServletContext getServletContext() {
            Object ret = this.invokeObjectMethod(GET_SERVLET_CONTEXT, new Object[0]);
            return ret != null ? new ServletContext(ret) : null;
        }
    }
}

