/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.tinylog.pattern;

import com.appland.shade.org.tinylog.core.LogEntry;
import com.appland.shade.org.tinylog.core.LogEntryValue;
import com.appland.shade.org.tinylog.pattern.Token;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;

final class MessageToken
implements Token {
    private static final String NEW_LINE = System.getProperty("line.separator");

    MessageToken() {
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return Collections.singleton(LogEntryValue.MESSAGE);
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        block3: {
            String message = logEntry.getMessage();
            if (message == null) break block3;
            int cartridgeReturn = message.indexOf(13);
            int lineFeed = message.indexOf(10);
            int position = 0;
            while (true) {
                if (cartridgeReturn >= 0 && (lineFeed < 0 || cartridgeReturn < lineFeed)) {
                    builder.append(message, position, cartridgeReturn);
                    builder.append(NEW_LINE);
                    position = cartridgeReturn + 1;
                    cartridgeReturn = message.indexOf(13, position);
                    continue;
                }
                if (lineFeed < 0) break;
                if (position == 0 || message.charAt(position - 1) != '\r') {
                    builder.append(message, position, lineFeed);
                    builder.append(NEW_LINE);
                }
                position = lineFeed + 1;
                lineFeed = message.indexOf(10, position);
            }
            builder.append(message, position, message.length());
        }
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        statement.setString(index, logEntry.getMessage());
    }
}

