/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.tinylog.pattern;

import com.appland.shade.org.tinylog.Level;
import com.appland.shade.org.tinylog.core.LogEntry;
import com.appland.shade.org.tinylog.core.LogEntryValue;
import com.appland.shade.org.tinylog.pattern.Token;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;

final class SeverityLevelIntegerToken
implements Token {
    private static final int LEVEL_COUNT = Level.OFF.ordinal();

    SeverityLevelIntegerToken() {
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return Collections.singleton(LogEntryValue.LEVEL);
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        builder.append(this.getReverseOfOrdinalAsLevelValue(logEntry));
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        statement.setInt(index, this.getReverseOfOrdinalAsLevelValue(logEntry));
    }

    private int getReverseOfOrdinalAsLevelValue(LogEntry logEntry) {
        return LEVEL_COUNT - logEntry.getLevel().ordinal();
    }
}

