/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.tinylog.writers.raw;

import com.appland.shade.org.tinylog.writers.raw.ByteArrayWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public final class LockedRandomAccessFileWriter
implements ByteArrayWriter {
    private final RandomAccessFile file;

    public LockedRandomAccessFileWriter(RandomAccessFile file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readTail(byte[] data, int offset, int length) throws IOException {
        FileChannel channel = this.file.getChannel();
        FileLock lock = channel.lock();
        try {
            long fileSize = channel.size();
            int bytesToRead = (int)Math.min(fileSize, (long)length);
            channel.position(fileSize - (long)bytesToRead);
            int n = this.file.read(data, offset, bytesToRead);
            return n;
        }
        finally {
            lock.release();
        }
    }

    @Override
    public void write(byte[] data, int length) throws IOException {
        this.write(data, 0, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        FileChannel channel = this.file.getChannel();
        FileLock lock = channel.lock();
        try {
            channel.position(channel.size());
            this.file.write(data, offset, length);
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(int count) throws IOException {
        FileChannel channel = this.file.getChannel();
        FileLock lock = channel.lock();
        try {
            this.file.setLength(Math.max(0L, channel.size() - (long)count));
        }
        finally {
            lock.release();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }
}

