/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.reflections.scanners;

import com.appland.shade.org.reflections.scanners.AbstractScanner;
import com.appland.shade.org.reflections.util.FilterBuilder;

public class SubTypesScanner
extends AbstractScanner {
    public SubTypesScanner() {
        this(true);
    }

    public SubTypesScanner(boolean excludeObjectClass) {
        if (excludeObjectClass) {
            this.filterResultsBy(new FilterBuilder().exclude(Object.class.getName()));
        }
    }

    @Override
    public void scan(Object cls) {
        String className = this.getMetadataAdapter().getClassName(cls);
        String superclass = this.getMetadataAdapter().getSuperclassName(cls);
        if (this.acceptResult(superclass)) {
            this.getStore().put(superclass, className);
        }
        for (String anInterface : this.getMetadataAdapter().getInterfacesNames(cls)) {
            if (!this.acceptResult(anInterface)) continue;
            this.getStore().put(anInterface, className);
        }
    }
}

