/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.tinylog.configuration;

import com.appland.shade.org.tinylog.Level;
import com.appland.shade.org.tinylog.provider.InternalLogger;
import com.appland.shade.org.tinylog.runtime.RuntimeProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public final class ServiceLoader<T> {
    private static final String SERVICE_PREFIX = "META-INF/services/";
    private static final Pattern SPLIT_PATTERN = Pattern.compile(" ");
    private final Class<? extends T> service;
    private final Class<?>[] argumentTypes;
    private final ClassLoader classLoader;
    private final Collection<String> classes;

    public ServiceLoader(Class<? extends T> service, Class<?> ... argumentTypes) {
        this.service = service;
        this.argumentTypes = argumentTypes;
        String fileName = SERVICE_PREFIX + service.getName();
        for (ClassLoader loader : RuntimeProvider.getClassLoaders()) {
            Enumeration<URL> serviceFiles = ServiceLoader.fetchServiceFiles(loader, fileName);
            if (!serviceFiles.hasMoreElements()) continue;
            this.classLoader = loader;
            this.classes = ServiceLoader.loadClasses(loader, service);
            return;
        }
        this.classLoader = null;
        this.classes = Collections.emptyList();
    }

    public T create(String name, Object ... arguments) {
        if (name.indexOf(46) == -1) {
            String expectingClassName = this.toSimpleClassName(name);
            for (String className : this.classes) {
                int split = className.lastIndexOf(46);
                String simpleClassName = split == -1 ? className : className.substring(split + 1);
                if (!expectingClassName.equals(simpleClassName)) continue;
                return this.createInstance(className, arguments);
            }
            InternalLogger.log(Level.ERROR, "Service implementation '" + name + "' not found");
            return null;
        }
        return this.createInstance(name, arguments);
    }

    public List<T> createList(String list) {
        ArrayList<T> instances = new ArrayList<T>();
        for (String entry : list.split(",")) {
            T instance;
            if ((entry = entry.trim()).isEmpty()) continue;
            int separator = entry.indexOf(58);
            if (separator == -1) {
                instance = this.create(entry, new Object[]{null});
            } else {
                String name = entry.substring(0, separator).trim();
                String argument = entry.substring(separator + 1).trim();
                instance = this.create(name, argument);
            }
            if (instance == null) continue;
            instances.add(instance);
        }
        return instances;
    }

    public Collection<T> createAll(Object ... arguments) {
        ArrayList<T> instances = new ArrayList<T>(this.classes.size());
        for (String className : this.classes) {
            T instance = this.createInstance(className, arguments);
            if (instance == null) continue;
            instances.add(instance);
        }
        return instances;
    }

    private static Enumeration<URL> fetchServiceFiles(ClassLoader classLoader, String fileName) {
        try {
            return classLoader.getResources(fileName);
        }
        catch (IOException ex) {
            InternalLogger.log(Level.ERROR, "Failed loading services from '" + fileName + "'");
            return Collections.enumeration(Collections.emptyList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Collection<String> loadClasses(ClassLoader classLoader, Class<? extends T> service) {
        Enumeration<URL> urls;
        String name = SERVICE_PREFIX + service.getName();
        try {
            urls = classLoader.getResources(name);
        }
        catch (IOException ex) {
            InternalLogger.log(Level.ERROR, "Failed loading services from '" + name + "'");
            return Collections.emptyList();
        }
        ArrayList<String> classes = new ArrayList<String>();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));
                String line = reader.readLine();
                while (line != null) {
                    if ((line = line.trim()).length() > 0 && line.charAt(0) != '#' && !classes.contains(line)) {
                        classes.add(line);
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException ex) {
                InternalLogger.log(Level.ERROR, "Failed reading service resource '" + url + "'");
            }
            finally {
                if (reader == null) continue;
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return classes;
    }

    public String toSimpleClassName(String name) {
        StringBuilder builder = new StringBuilder(name.length());
        for (String token : SPLIT_PATTERN.split(name)) {
            if (token.isEmpty()) continue;
            builder.append(Character.toUpperCase(token.charAt(0)));
            builder.append(token.substring(1).toLowerCase(Locale.ROOT));
        }
        builder.append(this.service.getSimpleName());
        return builder.toString();
    }

    private T createInstance(String className, Object ... arguments) {
        try {
            Class<?> implementation = Class.forName(className, false, this.classLoader);
            if (this.service.isAssignableFrom(implementation)) {
                return (T)implementation.getDeclaredConstructor(this.argumentTypes).newInstance(arguments);
            }
            InternalLogger.log(Level.ERROR, "Class '" + className + "' does not implement service interface '" + this.service + "'");
        }
        catch (ClassNotFoundException ex) {
            InternalLogger.log(Level.ERROR, "Service implementation '" + className + "' not found");
        }
        catch (NoSuchMethodException ex) {
            InternalLogger.log(Level.ERROR, "Service implementation '" + className + "' has no matching constructor");
        }
        catch (InstantiationException ex) {
            InternalLogger.log(Level.ERROR, "Service implementation '" + className + "' is not instantiable");
        }
        catch (IllegalAccessException ex) {
            InternalLogger.log(Level.ERROR, "Constructor of service implementation '" + className + "' is not accessible");
        }
        catch (IllegalArgumentException ex) {
            InternalLogger.log(Level.ERROR, "Illegal arguments for constructor of service implementation '" + className + "'");
        }
        catch (InvocationTargetException ex) {
            InternalLogger.log(Level.ERROR, ex.getTargetException(), "Failed creating service implementation '" + className + "'");
        }
        return null;
    }
}

