/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.config;

import com.appland.appmap.Agent;
import com.appland.appmap.cli.CLI;
import com.appland.appmap.config.AppMapPackage;
import com.appland.appmap.config.Properties;
import com.appland.appmap.util.FullyQualifiedName;
import com.appland.shade.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.appland.shade.com.fasterxml.jackson.annotation.JsonProperty;
import com.appland.shade.com.fasterxml.jackson.databind.ObjectMapper;
import com.appland.shade.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.appland.shade.org.tinylog.Logger;
import com.appland.shade.org.tinylog.TaggedLogger;
import com.appland.shade.org.tinylog.configuration.Configuration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AppMapConfig {
    private static final TaggedLogger logger = AppMapConfig.configureLogging();
    public Path configFile;
    public String name;
    public AppMapPackage[] packages = new AppMapPackage[0];
    private String appmapDir;
    private static AppMapConfig singleton = new AppMapConfig();

    @JsonProperty(value="appmap_dir")
    String getAppmapDir() {
        return this.appmapDir;
    }

    public static TaggedLogger getLogger(String tag) {
        return Logger.tag(tag);
    }

    private static Path findConfig(Path configFile, boolean mustExist) throws FileNotFoundException {
        Path projectDirectory;
        if (Files.exists(configFile, new LinkOption[0])) {
            return configFile;
        }
        if (mustExist) {
            throw new FileNotFoundException(configFile.toString());
        }
        for (Path parent = projectDirectory = configFile.toAbsolutePath().getParent(); parent != null; parent = parent.getParent()) {
            Path c = parent.resolve("appmap.yml");
            if (!Files.exists(c, new LinkOption[0])) continue;
            return c;
        }
        try {
            Files.createDirectories(projectDirectory, new FileAttribute[0]);
            Files.write(configFile, AppMapConfig.getDefault(projectDirectory.toString()).getBytes(), new OpenOption[0]);
            return configFile;
        }
        catch (IOException e) {
            logger.error((Throwable)e, "Failed to create default config");
            throw new FileNotFoundException(configFile.toString());
        }
    }

    static AppMapConfig load(Path configFile, boolean mustExist) {
        InputStream inputStream = null;
        try {
            configFile = AppMapConfig.findConfig(configFile, mustExist);
            logger.debug("using config file -> {}", configFile.toAbsolutePath());
            inputStream = Files.newInputStream(configFile, new OpenOption[0]);
        }
        catch (IOException e) {
            Path expectedConfig = configFile.toAbsolutePath();
            logger.error("error: file not found -> {}", expectedConfig);
            return null;
        }
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        try {
            singleton = mapper.readValue(inputStream, AppMapConfig.class);
        }
        catch (IOException e) {
            logger.error("AppMap: encountered syntax error in appmap.yml {}", e.getMessage());
            System.exit(1);
        }
        AppMapConfig.singleton.configFile = configFile;
        logger.debug("config: {}", singleton);
        return singleton;
    }

    public static AppMapConfig get() {
        return singleton;
    }

    public AppMapPackage.LabelConfig includes(FullyQualifiedName canonicalName) {
        if (this.packages == null) {
            return null;
        }
        for (AppMapPackage pkg : this.packages) {
            AppMapPackage.LabelConfig ls = pkg.find(canonicalName);
            if (ls == null) continue;
            return ls;
        }
        return null;
    }

    public Boolean excludes(FullyQualifiedName canonicalName) {
        if (this.packages == null) {
            return false;
        }
        for (AppMapPackage pkg : this.packages) {
            if (!pkg.excludes(canonicalName).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isShallow(FullyQualifiedName canonicalName) {
        if (canonicalName == null) {
            return false;
        }
        for (AppMapPackage pkg : this.packages) {
            if (pkg.find(canonicalName) == null) continue;
            return pkg.shallow;
        }
        return false;
    }

    public static String getDefault(String directory) throws IOException {
        StringWriter sw = new StringWriter();
        final PrintWriter pw = new PrintWriter(sw);
        pw.println("# This is the AppMap configuration file.");
        pw.println("# For full documentation of this file for Java programs, see:");
        pw.println("# https://appmap.io/docs/reference/appmap-java.html#configuration");
        pw.format("name: %s\n", CLI.projectName(new File(directory)));
        Path javaDir = Paths.get(directory, new String[0]).resolve("src/main/java");
        if (Files.isDirectory(javaDir, new LinkOption[0])) {
            final int pkgStart = javaDir.getNameCount();
            final HashSet packages = new HashSet();
            Files.walkFileTree(javaDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (file.getFileName().toString().endsWith(".java")) {
                        int pkgEnd = file.getParent().getNameCount();
                        if (pkgStart == pkgEnd) {
                            return FileVisitResult.CONTINUE;
                        }
                        Path packagePath = file.getParent().subpath(pkgStart, pkgEnd);
                        if (packagePath.getNameCount() > 0) {
                            packages.add(packagePath);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            pw.print("\n# Your project contains the directory src/main/java. AppMap has\n# auto-detected the following Java packages in this directory:\npackages:\n");
            List topLevelPackages = packages.stream().sorted().collect(ArrayList::new, (memo, packagePath) -> {
                for (int i = 1; i < packagePath.getNameCount(); ++i) {
                    Path ancestorPath = packagePath.subpath(0, i);
                    if (!memo.contains(ancestorPath)) continue;
                    return;
                }
                memo.add(packagePath);
            }, ArrayList::addAll);
            topLevelPackages.forEach(new Consumer<Path>(){

                @Override
                public void accept(Path packagePath) {
                    ArrayList<String> tokens = new ArrayList<String>();
                    for (int i = 0; i < packagePath.getNameCount(); ++i) {
                        tokens.add(packagePath.getName(i).toString());
                    }
                    String path = String.join((CharSequence)".", tokens);
                    pw.format("- path: %s\n", path);
                }
            });
        } else {
            pw.println("packages: []");
            pw.println("# appmap-java init looks for source packages in src/main/java.");
            pw.println("# This folder was not found in your project, so no packages were auto-detected.");
            pw.println("# You can add your source packages by replacing the line above with lines like this:");
            pw.println("# packages:");
            pw.println("# - path: com.mycorp.pkg");
            pw.println("# - path: org.otherstuff.pkg");
        }
        return sw.toString();
    }

    public static TaggedLogger configureLogging() {
        if (Properties.Debug.booleanValue()) {
            Configuration.set("level", "debug");
        }
        if (Properties.DebugFile != null) {
            Configuration.set("writer", "file");
            Configuration.set("writer.file", Properties.DebugFile);
        }
        return Logger.tag(null);
    }

    public static void initialize(FileSystem fs) throws IOException {
        String outputDirectory;
        String configFile;
        boolean configSpecified = Properties.ConfigFile != null;
        String string = configFile = !configSpecified ? "appmap.yml" : Properties.ConfigFile;
        if (AppMapConfig.load(fs.getPath(configFile, new String[0]), configSpecified) == null) {
            Agent.logger.error("failed to load config {}", Properties.ConfigFile);
            System.exit(1);
        }
        if ((outputDirectory = System.getProperty("appmap.output.directory")) == null) {
            if (AppMapConfig.singleton.appmapDir == null) {
                AppMapConfig.singleton.appmapDir = AppMapConfig.findDefaultOutputDirectory(fs).toString();
            }
        } else if (AppMapConfig.singleton.appmapDir != null) {
            if (!outputDirectory.equals(AppMapConfig.singleton.appmapDir)) {
                Agent.logger.warn("{} specified, and appmap.yml contains appmap_dir. Using {} as output directory.", "appmap.output.directory", outputDirectory);
                AppMapConfig.singleton.appmapDir = outputDirectory;
            }
        } else {
            AppMapConfig.singleton.appmapDir = outputDirectory;
        }
        Properties.OutputDirectory = fs.getPath(AppMapConfig.singleton.appmapDir, new String[0]);
    }

    private static Path findDefaultOutputDirectory(FileSystem fs) {
        return fs.getPath("tmp/appmap", new String[0]);
    }
}

