/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks.remoterecording;

import com.appland.appmap.config.Properties;
import com.appland.appmap.process.hooks.remoterecording.RemoteRecordingManager;
import com.appland.appmap.process.hooks.remoterecording.ServletRequest;
import com.appland.appmap.reflect.DynamicReflectiveType;
import com.appland.appmap.reflect.HttpServletRequest;
import com.appland.appmap.reflect.HttpServletResponse;
import com.appland.appmap.reflect.ReflectiveType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class RemoteRecordingFilter
implements InvocationHandler {
    private RemoteRecordingFilter() {
    }

    public static Object build(ClassLoader cl) {
        return DynamicReflectiveType.build(new RemoteRecordingFilter(), cl, "javax.servlet.Filter", "jakarta.servlet.Filter", "org.springframework.core.Ordered");
    }

    private static void doFilter(Object[] args) {
        HttpServletRequest req = new HttpServletRequest(args[0]);
        HttpServletResponse res = new HttpServletResponse(args[1]);
        FilterChain chain = new FilterChain(args[2]);
        if (!Properties.RecordingRemote.booleanValue() || !RemoteRecordingManager.service(new ServletRequest(req, res))) {
            chain.doFilter(args[0], args[1]);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("doFilter")) {
            RemoteRecordingFilter.doFilter(args);
        } else {
            if (methodName.equals("getOrder")) {
                Class<?> methodClass = method.getDeclaringClass();
                Field highestPrecedence = methodClass.getField("HIGHEST_PRECEDENCE");
                return highestPrecedence.getInt(methodClass);
            }
            if (!methodName.equals("init") && !methodName.equals("destroy")) {
                throw new InternalError("unhandled method " + methodName);
            }
        }
        return null;
    }

    private static class FilterChain
    extends ReflectiveType {
        static String DO_FILTER = "doFilter";

        public FilterChain(Object self) {
            super(self);
            if (!this.addMethod(DO_FILTER, "javax.servlet.ServletRequest", "javax.servlet.ServletResponse") && !this.addMethod(DO_FILTER, "jakarta.servlet.ServletRequest", "jakarta.servlet.ServletResponse")) {
                throw new InternalError("No find doFilter method");
            }
        }

        public void doFilter(Object req, Object resp) {
            this.invokeVoidMethod(DO_FILTER, req, resp);
        }
    }
}

