/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.config.Properties;
import com.appland.appmap.output.v1.NoSourceAvailableException;
import com.appland.appmap.transform.annotations.Hook;
import com.appland.appmap.transform.annotations.HookSite;
import com.appland.appmap.transform.annotations.HookValidationException;
import com.appland.appmap.util.AppMapBehavior;
import com.appland.appmap.util.Logger;
import com.appland.shade.javassist.ClassPool;
import com.appland.shade.javassist.CtBehavior;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.javassist.CtMethod;
import com.appland.shade.javassist.LoaderClassPath;
import com.appland.shade.javassist.Modifier;
import com.appland.shade.javassist.NotFoundException;
import com.appland.shade.javassist.bytecode.Descriptor;
import com.appland.shade.org.reflections.Reflections;
import com.appland.shade.org.reflections.scanners.SubTypesScanner;
import com.appland.shade.org.reflections.util.ClasspathHelper;
import com.appland.shade.org.reflections.util.ConfigurationBuilder;
import com.appland.shade.org.reflections.util.FilterBuilder;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.io.ByteArrayInputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClassFileTransformer
implements java.lang.instrument.ClassFileTransformer {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);
    private static String tracePrefix = Properties.DebugClassPrefix;
    private static final List<Hook> unkeyedHooks = new ArrayList<Hook>();
    private static final Map<String, List<Hook>> keyedHooks = new HashMap<String, List<Hook>>();

    public ClassFileTransformer() {
        Reflections reflections = new Reflections(new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage("com.appland.appmap.process", new ClassLoader[0])).setScanners(new SubTypesScanner(false)).filterInputsBy(new FilterBuilder().includePackage("com.appland.appmap.process")));
        ClassPool classPool = ClassPool.getDefault();
        for (Class<Object> classType : reflections.getSubTypesOf(Object.class)) {
            try {
                CtClass ctClass = classPool.get(classType.getName());
                this.processClass(ctClass);
                ctClass.detach();
            }
            catch (NotFoundException e) {
                Logger.printf("failed to find %s in class pool", classType.getName());
                Logger.println(e);
            }
        }
    }

    private void addHook(Hook hook) {
        if (hook == null) {
            return;
        }
        String key = hook.getKey();
        logger.trace("{}: {}", key, hook);
        if (key == null) {
            unkeyedHooks.add(hook);
        } else {
            List matchingKeyedHooks = keyedHooks.computeIfAbsent(key, k -> new ArrayList());
            matchingKeyedHooks.add(hook);
        }
    }

    private List<Hook> getHooks(String methodId) {
        List<Hook> matchingKeyedHooks = keyedHooks.get(methodId);
        if (matchingKeyedHooks == null) {
            matchingKeyedHooks = new ArrayList<Hook>();
        }
        return Stream.of(matchingKeyedHooks, unkeyedHooks).flatMap(Collection::stream).sorted(Comparator.comparingInt(Hook::getPosition)).collect(Collectors.toList());
    }

    private void processClass(CtClass ctClass) {
        boolean traceClass;
        boolean bl = traceClass = logger.isTraceEnabled() && (tracePrefix == null || ctClass.getName().startsWith(tracePrefix));
        if (traceClass) {
            logger.trace(() -> ctClass.getName());
        }
        for (CtBehavior behavior : ctClass.getDeclaredBehaviors()) {
            Hook hook;
            if (traceClass) {
                logger.trace(() -> behavior.getLongName());
            }
            if ((hook = Hook.from(behavior)) == null) {
                if (!traceClass) continue;
                logger.trace("{}, no hooks", () -> behavior.getLongName());
                continue;
            }
            ctClass.defrost();
            try {
                hook.validate();
            }
            catch (HookValidationException e) {
                logger.debug((Throwable)e, "failed to validate hook");
                continue;
            }
            this.addHook(hook);
            if (!traceClass) continue;
            logger.trace("registered hook {}", hook);
        }
    }

    private boolean applyHooks(CtBehavior behavior) {
        boolean traceClass = logger.isTraceEnabled() && (tracePrefix == null || behavior.getDeclaringClass().getName().startsWith(tracePrefix));
        try {
            List<HookSite> hookSites = this.getHooks(behavior.getName()).stream().map(hook -> hook.prepare(behavior)).filter(Objects::nonNull).collect(Collectors.toList());
            if (hookSites.size() < 1) {
                if (traceClass) {
                    logger.trace("no hook sites");
                }
                return false;
            }
            Hook.apply(behavior, hookSites);
            if (logger.isDebugEnabled()) {
                for (HookSite hookSite : hookSites) {
                    Hook hook2 = hookSite.getHook();
                    String className = behavior.getDeclaringClass().getName();
                    if (tracePrefix != null && !className.startsWith(tracePrefix) || !traceClass) continue;
                    logger.debug("hooked {}.{}{} on ({},{}) with {}", className, behavior.getName(), behavior.getMethodInfo().getDescriptor(), hook2.getMethodEvent().getEventString(), hook2.getPosition(), hook2);
                }
            }
            return true;
        }
        catch (NoSourceAvailableException e) {
            Logger.println(e);
            return false;
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> redefiningClass, ProtectionDomain domain, byte[] bytes) throws IllegalClassFormatException {
        logger.trace("className: {}", className);
        ClassPool classPool = new ClassPool();
        try {
            CtClass ctClass;
            boolean traceClass;
            if (className == null) {
                return null;
            }
            className = className.replaceAll("/", ".");
            boolean bl = traceClass = logger.isTraceEnabled() && (tracePrefix == null || className.startsWith(tracePrefix));
            if (traceClass) {
                logger.trace("className: {}, classPool: {}", className, classPool);
            }
            classPool.appendClassPath(new LoaderClassPath(loader));
            try {
                ctClass = classPool.makeClass(new ByteArrayInputStream(bytes));
            }
            catch (RuntimeException e) {
                logger.warn((Throwable)e, "makeClass failed");
                return null;
            }
            if (ctClass.isInterface()) {
                if (traceClass) {
                    logger.trace("{} is an interface", className);
                }
                return null;
            }
            boolean hookApplied = false;
            for (CtBehavior behavior : ctClass.getDeclaredBehaviors()) {
                if (traceClass) {
                    logger.trace("behavior: {} ", behavior.getLongName());
                }
                if (this.ignoreMethod(behavior)) {
                    if (!traceClass) continue;
                    logger.trace("ignored");
                    continue;
                }
                if (!this.applyHooks(behavior)) continue;
                hookApplied = true;
            }
            if (hookApplied) {
                if (traceClass) {
                    logger.trace("hook(s) applied to {}", className);
                }
                return ctClass.toBytecode();
            }
            if (traceClass) {
                logger.trace("no hooks applied to {}", className);
            }
        }
        catch (Throwable t) {
            logger.warn(t);
        }
        return null;
    }

    private boolean ignoreMethod(CtBehavior behavior) {
        if (!(behavior instanceof CtMethod)) {
            return false;
        }
        if ((behavior.getModifiers() & 0x400) != 0) {
            return true;
        }
        CtMethod method = (CtMethod)behavior;
        try {
            return behavior.getMethodInfo2().isConstructor() || behavior.getMethodInfo2().isStaticInitializer() || ClassFileTransformer.isGetter(method) || ClassFileTransformer.isSetter(method) || this.isIgnoredInstanceMethod(method);
        }
        catch (NotFoundException e) {
            Logger.println(e);
            return true;
        }
    }

    private boolean isIgnoredInstanceMethod(CtMethod method) {
        int mods = method.getModifiers();
        if (Modifier.isStatic(mods) || !new AppMapBehavior(method).isRecordable().booleanValue()) {
            return false;
        }
        String methodName = method.getName();
        return methodName.equals("equals") || methodName.equals("hashCode") || methodName.equals("iterator") || methodName.equals("toString");
    }

    public static boolean isGetter(CtMethod method) throws NotFoundException {
        String descriptor = method.getMethodInfo().getDescriptor();
        String methodName = method.getName();
        if (new AppMapBehavior(method).isRecordable().booleanValue() && Descriptor.numOfParameters(descriptor) == 0) {
            if (methodName.matches("^get[A-Z].*") && !descriptor.matches("\\)V$")) {
                return true;
            }
            if (methodName.matches("^is[A-Z].*") && descriptor.matches("\\)Z$")) {
                return true;
            }
            return methodName.matches("^has[A-Z].*") && descriptor.matches("\\)Z$");
        }
        return false;
    }

    public static boolean isSetter(CtMethod method) throws NotFoundException {
        String descriptor = method.getMethodInfo().getDescriptor();
        return new AppMapBehavior(method).isRecordable() != false && descriptor.matches("\\)V$") && Descriptor.numOfParameters(descriptor) == 1 && method.getName().matches("^set[A-Z].*");
    }
}

