/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.config.Properties;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.record.Recording;
import com.appland.appmap.transform.ClassFileTransformer;
import com.appland.shade.org.tinylog.TaggedLogger;
import com.appland.shade.org.tinylog.provider.ProviderRegistry;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.jar.JarFile;

public class Agent {
    public static final TaggedLogger logger = AppMapConfig.getLogger(null);

    public static void premain(String agentArgs, Instrumentation inst) {
        logger.debug("Agent version {}", Agent.class.getPackage().getImplementationVersion());
        logger.debug("System properties: {}", System.getProperties());
        logger.debug((Throwable)new Exception(), "whereAmI");
        URL jarURL = Agent.class.getProtectionDomain().getCodeSource().getLocation();
        Path agentJar = Paths.get(jarURL.getPath(), new String[0]);
        JarFile jarFile = null;
        if (!Files.isDirectory(agentJar, new LinkOption[0])) {
            try {
                jarFile = new JarFile(Paths.get(jarURL.getPath(), new String[0]).toFile());
                inst.appendToSystemClassLoaderSearch(jarFile);
            }
            catch (IOException e) {
                System.err.println("Failed to load the agent jar");
                e.printStackTrace();
                System.exit(1);
            }
        }
        inst.addTransformer(new ClassFileTransformer());
        try {
            AppMapConfig.initialize(FileSystems.getDefault());
        }
        catch (IOException e) {
            logger.warn((Throwable)e, "Initialization failed");
            System.exit(1);
        }
        Runnable logShutdown = () -> {
            try {
                ProviderRegistry.getLoggingProvider().shutdown();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        };
        if (Properties.RecordingAuto.booleanValue()) {
            String appmapName = Properties.RecordingName;
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmss");
            String timestamp = dateFormat.format(date);
            Recorder.Metadata metadata = new Recorder.Metadata("java", "process");
            Recorder recorder = Recorder.getInstance();
            if (appmapName == null || appmapName.trim().isEmpty()) {
                appmapName = timestamp;
            }
            metadata.scenarioName = appmapName;
            recorder.start(metadata);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                String fileName = Properties.RecordingFile;
                if (fileName == null || fileName.trim().isEmpty()) {
                    fileName = String.format("%s.appmap.json", timestamp);
                }
                Recording recording = recorder.stop();
                recording.moveTo(fileName);
                logShutdown.run();
            }));
        } else {
            Runtime.getRuntime().addShutdownHook(new Thread(logShutdown));
        }
    }
}

