/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.output.v1.Event;
import com.appland.appmap.record.ActiveSessionException;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.record.Recording;
import com.appland.appmap.util.StringUtil;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.util.Objects;

public class RecordingSupport {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);
    private static final Recorder recorder = Recorder.getInstance();

    public static void startRecording(Event event, String recorderName, String recorderType) {
        RecordingSupport.startRecording(new TestDetails(event), recorderName, recorderType);
    }

    public static void startRecording(TestDetails details, String recorderName, String recorderType) {
        logger.debug("Recording started for {}", StringUtil.canonicalName(details.definedClass, details.isStatic, details.methodId));
        try {
            Recorder.Metadata metadata = new Recorder.Metadata(recorderName, recorderType);
            String feature = StringUtil.identifierToSentence(details.methodId);
            String featureGroup = StringUtil.identifierToSentence(details.definedClass);
            metadata.scenarioName = String.format("%s %s", featureGroup, StringUtil.decapitalize(feature));
            metadata.recordedClassName = details.definedClass;
            metadata.recordedMethodName = details.methodId;
            metadata.sourceLocation = String.join((CharSequence)":", details.path, details.lineNumber);
            recorder.start(metadata);
        }
        catch (ActiveSessionException e) {
            logger.warn(e);
        }
    }

    public static void stopRecording(Event event) {
        RecordingSupport.stopRecording(new TestDetails(event), true, null, null);
    }

    public static void stopRecording(Event event, boolean succeeded) {
        RecordingSupport.stopRecording(new TestDetails(event), succeeded, null, null);
    }

    public static void stopRecording(TestDetails details, Boolean succeeded, String failureMessage, Integer failureLine) {
        logger.debug("Recording stopped for {}", StringUtil.canonicalName(details.definedClass, details.isStatic, details.methodId));
        String filePath = Recorder.sanitizeFilename(String.join((CharSequence)"_", details.definedClass, details.methodId));
        filePath = filePath + ".appmap.json";
        Recorder.Metadata metadata = recorder.getMetadata();
        if (succeeded != null) {
            metadata.testSucceeded = succeeded;
        }
        if (!succeeded.booleanValue()) {
            metadata.failureMessage = failureMessage;
            metadata.failureLine = failureLine;
        }
        Recording recording = recorder.stop();
        recording.moveTo(filePath);
    }

    public static class TestDetails {
        public String definedClass;
        public boolean isStatic;
        public String methodId;
        public String path;
        public String lineNumber;

        protected TestDetails() {
        }

        public TestDetails(Event event) {
            Objects.requireNonNull(event);
            this.definedClass = event.definedClass;
            this.isStatic = event.isStatic;
            this.methodId = event.methodId;
            this.path = event.path;
            this.lineNumber = String.valueOf(event.lineNumber);
        }
    }
}

