/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks.test;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.output.v1.Event;
import com.appland.appmap.process.hooks.RecordingSupport;
import com.appland.appmap.reflect.DynamicReflectiveType;
import com.appland.appmap.reflect.ReflectiveType;
import com.appland.appmap.transform.annotations.ArgumentArray;
import com.appland.appmap.transform.annotations.HookClass;
import com.appland.appmap.util.ClassUtil;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Optional;

public class JUnit5 {
    public static final TaggedLogger logger = AppMapConfig.getLogger(null);
    static final String JUNIT_NAME = "junit";

    @ArgumentArray
    @HookClass(value="org.junit.platform.launcher.core.LauncherConfig$Builder")
    public static void build(Event event, Object receiver, Object[] args) {
        ClassLoader cl = receiver.getClass().getClassLoader();
        logger.trace("receiver: {}, receiver's class loader: {}", receiver.getClass().getName(), cl);
        Builder builder = new Builder(receiver);
        builder.addTestExecutionListener(TestExecutionListener.build(cl));
    }

    private static class TestExecutionListener
    implements InvocationHandler {
        private TestExecutionListener() {
        }

        public static Object build(ClassLoader cl) {
            return DynamicReflectiveType.build(new TestExecutionListener(), cl, "org.junit.platform.launcher.TestExecutionListener");
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("executionStarted")) {
                TestIdentifier id = new TestIdentifier(args[0]);
                logger.trace("executionStarted, id.isTest(): {}, id: {}", id.isTest(), id);
                if (!id.isTest().booleanValue()) {
                    return null;
                }
                TestIdentifier.MethodSource src = id.getSource();
                RecordingSupport.startRecording(new JUnit5Details(src), JUnit5.JUNIT_NAME, "tests");
            } else if (methodName.equals("executionFinished")) {
                TestIdentifier id = new TestIdentifier(args[0]);
                if (!id.isTest().booleanValue()) {
                    return null;
                }
                TestExecutionResult result = new TestExecutionResult(args[1]);
                logger.trace("executionFinished, result: {}", args[1]);
                TestIdentifier.MethodSource src = id.getSource();
                boolean succeeded = result.getStatus().equals(TestExecutionResult.SUCCESSFUL);
                String failureMessage = null;
                int failureLine = -1;
                Throwable t = result.getThrowable();
                JUnit5Details details = new JUnit5Details(src);
                logger.trace(t, "test failed at");
                if (t != null) {
                    failureMessage = t.getMessage();
                    if (details.definedClass != null && details.methodId != null) {
                        for (StackTraceElement ste : t.getStackTrace()) {
                            logger.trace("ste: {}", ste);
                            if (!ste.getClassName().equals(details.definedClass) || !ste.getMethodName().equals(details.methodId)) continue;
                            failureLine = ste.getLineNumber();
                            break;
                        }
                    }
                }
                RecordingSupport.stopRecording(details, succeeded, failureMessage, failureLine);
            } else {
                logger.trace("unhandled method {}", methodName);
            }
            return null;
        }

        class JUnit5Details
        extends RecordingSupport.TestDetails {
            JUnit5Details(TestIdentifier.MethodSource src) {
                if (src == null) {
                    return;
                }
                this.definedClass = src.getClassName();
                this.isStatic = false;
                this.methodId = src.getMethodName();
                ClassUtil.MethodLocation loc = ClassUtil.getMethodLocation(src.getClassName(), src.getMethodName(), src.getMethodParameterTypes());
                if (loc == null) {
                    return;
                }
                this.path = loc.file;
                this.lineNumber = String.valueOf(loc.line);
            }
        }
    }

    private static class TestExecutionResult
    extends ReflectiveType {
        private static String GET_STATUS = "getStatus";
        private static String GET_THROWABLE = "getThrowable";
        static Enum<?> SUCCESSFUL;

        public TestExecutionResult(Object self) {
            super(self);
            this.addMethods(GET_STATUS, GET_THROWABLE);
            SUCCESSFUL = ClassUtil.enumValueOf(this.getClassLoader(), "SUCCESSFUL", "org.junit.platform.engine.TestExecutionResult$Status");
        }

        public Object getStatus() {
            return this.invokeObjectMethod(GET_STATUS, new Object[0]);
        }

        public Throwable getThrowable() {
            Optional ret = (Optional)this.invokeObjectMethod(GET_THROWABLE, new Object[0]);
            return ret.isPresent() ? (Throwable)ret.get() : null;
        }
    }

    private static class TestIdentifier
    extends ReflectiveType {
        private static String GET_SOURCE = "getSource";
        private static String IS_TEST = "isTest";

        public TestIdentifier(Object self) {
            super(self);
            this.addMethods(GET_SOURCE, IS_TEST);
        }

        public Boolean isTest() {
            return (Boolean)this.invokeObjectMethod(IS_TEST, new Object[0]);
        }

        public MethodSource getSource() {
            Optional ret = (Optional)this.invokeObjectMethod(GET_SOURCE, new Object[0]);
            return ret.isPresent() ? new MethodSource(ret.get()) : null;
        }

        static class MethodSource
        extends ReflectiveType {
            private static String GET_CLASS_NAME = "getClassName";
            private static String GET_METHOD_NAME = "getMethodName";
            private static String GET_METHOD_PARAMETER_TYPES = "getMethodParameterTypes";

            public MethodSource(Object self) {
                super(self);
                this.addMethods(GET_CLASS_NAME, GET_METHOD_NAME, GET_METHOD_PARAMETER_TYPES);
            }

            public String getClassName() {
                return (String)this.invokeObjectMethod(GET_CLASS_NAME, new Object[0]);
            }

            public String getMethodName() {
                return (String)this.invokeObjectMethod(GET_METHOD_NAME, new Object[0]);
            }

            public String getMethodParameterTypes() {
                return (String)this.invokeObjectMethod(GET_METHOD_PARAMETER_TYPES, new Object[0]);
            }
        }
    }

    private static class Builder
    extends ReflectiveType {
        private static String ADD_TEST_EXECUTION_LISTENERS = "addTestExecutionListeners";
        private Object listenerArrayArg = Array.newInstance(ClassUtil.safeClassForName(this.getClassLoader(), "org.junit.platform.launcher.TestExecutionListener"), 1);

        public Builder(Object self) {
            super(self);
            this.addMethod(ADD_TEST_EXECUTION_LISTENERS, this.listenerArrayArg.getClass());
        }

        public void addTestExecutionListener(Object listener) {
            Array.set(this.listenerArrayArg, 0, listener);
            this.invokeVoidMethod(ADD_TEST_EXECUTION_LISTENERS, this.listenerArrayArg);
        }
    }
}

