/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.config.Properties;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.record.Recording;
import com.appland.appmap.transform.ClassFileTransformer;
import com.appland.appmap.transform.annotations.HookFactory;
import com.appland.appmap.transform.instrumentation.BBTransformer;
import com.appland.appmap.util.GitUtil;
import com.appland.shade.org.tinylog.TaggedLogger;
import com.appland.shade.org.tinylog.provider.ProviderRegistry;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.jar.JarFile;

public class Agent {
    public static final TaggedLogger logger = AppMapConfig.getLogger(null);

    public static void premain(String agentArgs, Instrumentation inst) {
        long start = System.currentTimeMillis();
        try {
            AppMapConfig.initialize(FileSystems.getDefault());
        }
        catch (IOException e) {
            logger.warn((Throwable)e, "Initialization failed");
            System.exit(1);
        }
        if (Properties.DisableLogFile == null) {
            logger.info("To disable the automatic creation of this log file, set the system property {} to 'true'", "appmap.disableLogFile");
        }
        logger.info("Agent version {}, current time mills: {}", Agent.class.getPackage().getImplementationVersion(), start);
        logger.info("config: {}", AppMapConfig.get());
        logger.info("System properties: {}", System.getProperties());
        logger.debug((Throwable)new Exception(), "whereAmI");
        Agent.addAgentJar(inst);
        try {
            GitUtil.findSourceRoots();
            logger.debug("done finding source roots, {}", () -> {
                long now = System.currentTimeMillis();
                return String.format("%d, %d", now - start, start);
            });
        }
        catch (IOException e) {
            logger.warn(e);
        }
        ClassFileTransformer methodCallTransformer = new ClassFileTransformer("method call", HookFactory.APP_HOOKS_FACTORY);
        inst.addTransformer(methodCallTransformer);
        BBTransformer.installOn(inst);
        ClassFileTransformer systemHookTransformer = new ClassFileTransformer("system hook", HookFactory.AGENT_HOOKS_FACTORY);
        inst.addTransformer(systemHookTransformer);
        Runnable logShutdown = () -> {
            try {
                ClassFileTransformer.logStatistics();
                ProviderRegistry.getLoggingProvider().shutdown();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        };
        if (Properties.RecordingAuto.booleanValue()) {
            Agent.startAutoRecording(logShutdown);
        } else {
            Runtime.getRuntime().addShutdownHook(new Thread(logShutdown));
        }
    }

    private static void startAutoRecording(Runnable logShutdown) {
        String appmapName = Properties.RecordingName;
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmss");
        String timestamp = dateFormat.format(date);
        Recorder.Metadata metadata = new Recorder.Metadata("java", "process");
        Recorder recorder = Recorder.getInstance();
        if (appmapName == null || appmapName.trim().isEmpty()) {
            appmapName = timestamp;
        }
        metadata.scenarioName = appmapName;
        recorder.start(metadata);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            String fileName = Properties.RecordingFile;
            if (fileName == null || fileName.trim().isEmpty()) {
                fileName = String.format("%s.appmap.json", timestamp);
            }
            Recording recording = recorder.stop();
            recording.moveTo(fileName);
            logShutdown.run();
        }));
    }

    private static void addAgentJar(Instrumentation inst) {
        URL jarURL;
        ProtectionDomain protectionDomain = Agent.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null || (jarURL = codeSource.getLocation()) == null) {
            return;
        }
        Path agentJar = null;
        try {
            agentJar = Paths.get(jarURL.toURI());
        }
        catch (URISyntaxException e) {
            System.err.println("Failed getting path to agent jar");
            e.printStackTrace();
            System.exit(1);
        }
        JarFile jarFile = null;
        if (!Files.isDirectory(agentJar, new LinkOption[0])) {
            try {
                jarFile = new JarFile(agentJar.toFile());
                inst.appendToSystemClassLoaderSearch(jarFile);
            }
            catch (IOException e) {
                System.err.println("Failed to load the agent jar");
                e.printStackTrace();
                System.exit(1);
            }
        }
    }
}

